/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers.pages;

import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.runner.RunnerType;
import com.google.jstestdriver.server.handlers.pages.PageType;
import com.google.jstestdriver.util.HtmlWriter;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlavePageRequest {
    public static final String PAGE = "page";
    public static final String ID = "id";
    public static final String MODE = "mode";
    public static final String TIMEOUT = "timeout";
    public static final String UPLOAD_SIZE = "upload_size";
    private static final Logger logger = LoggerFactory.getLogger(SlavePageRequest.class);
    private final Map<String, String> parameters;
    private final HttpServletRequest request;
    private final HandlerPathPrefix prefix;
    private final CapturedBrowsers browsers;

    public SlavePageRequest(Map<String, String> parameters, HttpServletRequest request, HandlerPathPrefix prefix, CapturedBrowsers browsers) {
        this.parameters = parameters;
        this.request = request;
        this.prefix = prefix;
        this.browsers = browsers;
    }

    public HtmlWriter writeDTD(HtmlWriter writer) throws IOException {
        if ("strict".equals(this.parameters.get(MODE))) {
            writer.writeStrictDtd();
        } else {
            writer.writeQuirksDtd();
        }
        return writer;
    }

    public String createCaptureUrl(RunnerType type) {
        return this.prefix.prefixPath(String.format("/capture/%s/%s/%s/%s/%s/%s", new Object[]{"rt", type, MODE, this.parameters.get(MODE), UPLOAD_SIZE, this.parameters.get(UPLOAD_SIZE)}));
    }

    public String createCaptureUrl() {
        return this.createCaptureUrl(RunnerType.valueOf(this.parameters.get("rt").toUpperCase()));
    }

    public String createPageUrl(PageType page) {
        String url = this.prefix.prefixPath(String.format("/%s/%s/%s/%s/%s/%s/%s/%s/%s/%s/%s", new Object[]{"slave", ID, this.parameters.get(ID), "rt", this.parameters.get("rt"), MODE, this.parameters.get(MODE), PAGE, page, UPLOAD_SIZE, this.parameters.get(UPLOAD_SIZE)}));
        logger.trace("creating new url: {} for {}", (Object)url, (Object)page);
        return url;
    }

    public SlaveBrowser getBrowser() {
        String id = this.parameters.get(ID);
        if (id == null) {
            return null;
        }
        return this.browsers.getBrowser(id);
    }

    public PageType getPageType() {
        return PageType.valueOf(this.parameters.get(PAGE).toUpperCase());
    }

    public String getUserAgent() {
        return this.request.getHeader("User-Agent");
    }

    public String toString() {
        return "SlavePageRequest [parameters=" + this.parameters + "]";
    }
}

