/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.coverage.CoverageAccumulator;
import com.google.jstestdriver.coverage.FileCoverage;
import com.google.jstestdriver.coverage.FileCoverageDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class CoverageTestResponseStream
implements ResponseStream {
    public static final String COVERAGE_DATA_KEY = "linesCovered";
    private final String browserId;
    private final CoverageAccumulator accumulator;
    private final TestResultGenerator generator;
    private final FileCoverageDeserializer deserializer = new FileCoverageDeserializer();

    public CoverageTestResponseStream(String browserId, CoverageAccumulator coverageReporter, TestResultGenerator generator) {
        this.browserId = browserId;
        this.accumulator = coverageReporter;
        this.generator = generator;
    }

    public void finish() {
    }

    public void stream(Response response) {
        if (response.getResponseType() != Response.ResponseType.TEST_RESULT) {
            return;
        }
        try {
            Collection testResults = this.generator.getTestResults(response);
            for (TestResult testResult : testResults) {
                String coveredLines = (String)testResult.getData().get(COVERAGE_DATA_KEY);
                if (coveredLines == null) continue;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(coveredLines.getBytes("UTF-8"));
                List<FileCoverage> lines = this.deserializer.deserializeCoverages(inputStream);
                this.accumulator.add(this.browserId, lines);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

