/* cnpIafrate2.c was originally generated by the autoSql program, which also 
 * generated cnpIafrate2.h and cnpIafrate2.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cnpIafrate2.h"


void cnpIafrate2StaticLoad(char **row, struct cnpIafrate2 *ret)
/* Load a row from cnpIafrate2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->normalGain = sqlUnsigned(row[4]);
ret->normalLoss = sqlUnsigned(row[5]);
ret->patientGain = sqlUnsigned(row[6]);
ret->patientLoss = sqlUnsigned(row[7]);
ret->total = sqlUnsigned(row[8]);
ret->cohortType = row[9];
}

struct cnpIafrate2 *cnpIafrate2Load(char **row)
/* Load a cnpIafrate2 from row fetched with select * from cnpIafrate2
 * from database.  Dispose of this with cnpIafrate2Free(). */
{
struct cnpIafrate2 *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->normalGain = sqlUnsigned(row[4]);
ret->normalLoss = sqlUnsigned(row[5]);
ret->patientGain = sqlUnsigned(row[6]);
ret->patientLoss = sqlUnsigned(row[7]);
ret->total = sqlUnsigned(row[8]);
ret->cohortType = cloneString(row[9]);
return ret;
}

struct cnpIafrate2 *cnpIafrate2LoadAll(char *fileName) 
/* Load all cnpIafrate2 from a whitespace-separated file.
 * Dispose of this with cnpIafrate2FreeList(). */
{
struct cnpIafrate2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = cnpIafrate2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpIafrate2 *cnpIafrate2LoadAllByChar(char *fileName, char chopper) 
/* Load all cnpIafrate2 from a chopper separated file.
 * Dispose of this with cnpIafrate2FreeList(). */
{
struct cnpIafrate2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cnpIafrate2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpIafrate2 *cnpIafrate2CommaIn(char **pS, struct cnpIafrate2 *ret)
/* Create a cnpIafrate2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpIafrate2 */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->normalGain = sqlUnsignedComma(&s);
ret->normalLoss = sqlUnsignedComma(&s);
ret->patientGain = sqlUnsignedComma(&s);
ret->patientLoss = sqlUnsignedComma(&s);
ret->total = sqlUnsignedComma(&s);
ret->cohortType = sqlStringComma(&s);
*pS = s;
return ret;
}

void cnpIafrate2Free(struct cnpIafrate2 **pEl)
/* Free a single dynamically allocated cnpIafrate2 such as created
 * with cnpIafrate2Load(). */
{
struct cnpIafrate2 *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->cohortType);
freez(pEl);
}

void cnpIafrate2FreeList(struct cnpIafrate2 **pList)
/* Free a list of dynamically allocated cnpIafrate2's */
{
struct cnpIafrate2 *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cnpIafrate2Free(&el);
    }
*pList = NULL;
}

void cnpIafrate2Output(struct cnpIafrate2 *el, FILE *f, char sep, char lastSep) 
/* Print out cnpIafrate2.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->normalGain);
fputc(sep,f);
fprintf(f, "%u", el->normalLoss);
fputc(sep,f);
fprintf(f, "%u", el->patientGain);
fputc(sep,f);
fprintf(f, "%u", el->patientLoss);
fputc(sep,f);
fprintf(f, "%u", el->total);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cohortType);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

