/* gbMembers.c was originally generated by the autoSql program, which also 
 * generated gbMembers.h and gbMembers.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gbMembers.h"


void gbMembersStaticLoad(char **row, struct gbMembers *ret)
/* Load a row from gbMembers table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->idx = sqlUnsigned(row[0]);
ret->userName = row[1];
ret->realName = row[2];
ret->password = row[3];
ret->email = row[4];
ret->lastUse = row[5];
ret->newPassword = row[6];
ret->newPasswordExpire = row[7];
ret->dateActivated = row[8];
ret->emailToken = row[9];
ret->emailTokenExpires = row[10];
safecpy(ret->passwordChangeRequired, sizeof(ret->passwordChangeRequired), row[11]);
safecpy(ret->accountActivated, sizeof(ret->accountActivated), row[12]);
}

struct gbMembers *gbMembersLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all gbMembers from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gbMembersFreeList(). */
{
struct gbMembers *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = gbMembersLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void gbMembersSaveToDb(struct sqlConnection *conn, struct gbMembers *el, char *tableName, int updateSize)
/* Save gbMembers as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')", 
	tableName,  el->idx,  el->userName,  el->realName,  el->password,  el->email,  el->lastUse,  el->newPassword,  el->newPasswordExpire,  el->dateActivated,  el->emailToken,  el->emailTokenExpires,  el->passwordChangeRequired,  el->accountActivated);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}


struct gbMembers *gbMembersLoad(char **row)
/* Load a gbMembers from row fetched with select * from gbMembers
 * from database.  Dispose of this with gbMembersFree(). */
{
struct gbMembers *ret;

AllocVar(ret);
ret->idx = sqlUnsigned(row[0]);
ret->userName = cloneString(row[1]);
ret->realName = cloneString(row[2]);
ret->password = cloneString(row[3]);
ret->email = cloneString(row[4]);
ret->lastUse = cloneString(row[5]);
ret->newPassword = cloneString(row[6]);
ret->newPasswordExpire = cloneString(row[7]);
ret->dateActivated = cloneString(row[8]);
ret->emailToken = cloneString(row[9]);
ret->emailTokenExpires = cloneString(row[10]);
safecpy(ret->passwordChangeRequired, sizeof(ret->passwordChangeRequired), row[11]);
safecpy(ret->accountActivated, sizeof(ret->accountActivated), row[12]);
return ret;
}

struct gbMembers *gbMembersLoadAll(char *fileName) 
/* Load all gbMembers from a whitespace-separated file.
 * Dispose of this with gbMembersFreeList(). */
{
struct gbMembers *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[13];

while (lineFileRow(lf, row))
    {
    el = gbMembersLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbMembers *gbMembersLoadAllByChar(char *fileName, char chopper) 
/* Load all gbMembers from a chopper separated file.
 * Dispose of this with gbMembersFreeList(). */
{
struct gbMembers *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[13];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gbMembersLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbMembers *gbMembersCommaIn(char **pS, struct gbMembers *ret)
/* Create a gbMembers out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gbMembers */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->idx = sqlUnsignedComma(&s);
ret->userName = sqlStringComma(&s);
ret->realName = sqlStringComma(&s);
ret->password = sqlStringComma(&s);
ret->email = sqlStringComma(&s);
ret->lastUse = sqlStringComma(&s);
ret->newPassword = sqlStringComma(&s);
ret->newPasswordExpire = sqlStringComma(&s);
ret->dateActivated = sqlStringComma(&s);
ret->emailToken = sqlStringComma(&s);
ret->emailTokenExpires = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->passwordChangeRequired, sizeof(ret->passwordChangeRequired));
sqlFixedStringComma(&s, ret->accountActivated, sizeof(ret->accountActivated));
*pS = s;
return ret;
}

void gbMembersFree(struct gbMembers **pEl)
/* Free a single dynamically allocated gbMembers such as created
 * with gbMembersLoad(). */
{
struct gbMembers *el;

if ((el = *pEl) == NULL) return;
freeMem(el->userName);
freeMem(el->realName);
freeMem(el->password);
freeMem(el->email);
freeMem(el->lastUse);
freeMem(el->newPassword);
freeMem(el->newPasswordExpire);
freeMem(el->dateActivated);
freeMem(el->emailToken);
freeMem(el->emailTokenExpires);
freez(pEl);
}

void gbMembersFreeList(struct gbMembers **pList)
/* Free a list of dynamically allocated gbMembers's */
{
struct gbMembers *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gbMembersFree(&el);
    }
*pList = NULL;
}

void gbMembersOutput(struct gbMembers *el, FILE *f, char sep, char lastSep) 
/* Print out gbMembers.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->idx);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->userName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->realName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->password);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->email);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lastUse);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->newPassword);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->newPasswordExpire);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dateActivated);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->emailToken);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->emailTokenExpires);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->passwordChangeRequired);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->accountActivated);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

