# gtexAse.sql was originally generated by the autoSql program, which also 
# generated gtexAse.c and gtexAse.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#BED9+ with additional fields for ASE, coverage, and sample count
CREATE TABLE gtexAse (
    chrom varchar(255) not null,	# Reference sequence chromosome or scaffold
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# SNP Id
    score int unsigned not null,	# Score from 0-1000; derived from median ASE level
    strand char(1) not null,	# n/a
    thickStart int unsigned not null,	# n/a
    thickEnd int unsigned not null,	# n/a
    itemRgb int unsigned not null,	# Color by ASE value
    medianASE float not null,	# Allelic imbalance (0-.5) median
    coverage float not null,	# RNA-seq reads overlapping this position (median)
    samples int unsigned not null,	# Sample count
    donors int unsigned not null,	# Donor count
    minASE float not null,	# Minimum ASE
    q1ASE float not null,	# Q1 ASE
    q3ASE float not null,	# Q3 ASE
    maxASE float not null,	# Maximum ASE
    stdASE float not null,	# ASE standard deviation
              #Indices
    INDEX(chrom(20), chromStart)
);
