/* ottoRequest.c was originally generated by the autoSql program, which also
 * generated ottoRequest.h and ottoRequest.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ottoRequest.h"



char *ottoRequestCommaSepFieldNames = "id,fromDb,toDb,email,comment,requestTime,doneStatus,completeTime";

void ottoRequestStaticLoad(char **row, struct ottoRequest *ret)
/* Load a row from ottoRequest table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fromDb = row[1];
ret->toDb = row[2];
ret->email = row[3];
ret->comment = row[4];
ret->requestTime = row[5];
ret->doneStatus = sqlUnsigned(row[6]);
ret->completeTime = row[7];
}

struct ottoRequest *ottoRequestLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all ottoRequest from table that satisfy the query given.
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something =
 * anotherTable.something'.
 * Dispose of this with ottoRequestFreeList(). */
{
struct ottoRequest *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = ottoRequestLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void ottoRequestSaveToDb(struct sqlConnection *conn, struct ottoRequest *el, char *tableName, int updateSize)
/* Save ottoRequest as a row to the table specified by tableName.
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s','%s','%s',%u,'%s')",
	tableName,  el->id,  el->fromDb,  el->toDb,  el->email,  el->comment,  el->requestTime,  el->doneStatus,  el->completeTime);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct ottoRequest *ottoRequestLoad(char **row)
/* Load a ottoRequest from row fetched with select * from ottoRequest
 * from database.  Dispose of this with ottoRequestFree(). */
{
struct ottoRequest *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fromDb = cloneString(row[1]);
ret->toDb = cloneString(row[2]);
ret->email = cloneString(row[3]);
ret->comment = cloneString(row[4]);
ret->requestTime = cloneString(row[5]);
ret->doneStatus = sqlUnsigned(row[6]);
ret->completeTime = cloneString(row[7]);
return ret;
}

struct ottoRequest *ottoRequestLoadAll(char *fileName)
/* Load all ottoRequest from a whitespace-separated file.
 * Dispose of this with ottoRequestFreeList(). */
{
struct ottoRequest *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = ottoRequestLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ottoRequest *ottoRequestLoadAllByChar(char *fileName, char chopper)
/* Load all ottoRequest from a chopper separated file.
 * Dispose of this with ottoRequestFreeList(). */
{
struct ottoRequest *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ottoRequestLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ottoRequest *ottoRequestCommaIn(char **pS, struct ottoRequest *ret)
/* Create a ottoRequest out of a comma separated string.
 * This will fill in ret if non-null, otherwise will
 * return a new ottoRequest */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fromDb = sqlStringComma(&s);
ret->toDb = sqlStringComma(&s);
ret->email = sqlStringComma(&s);
ret->comment = sqlStringComma(&s);
ret->requestTime = sqlStringComma(&s);
ret->doneStatus = sqlUnsignedComma(&s);
ret->completeTime = sqlStringComma(&s);
*pS = s;
return ret;
}

void ottoRequestFree(struct ottoRequest **pEl)
/* Free a single dynamically allocated ottoRequest such as created
 * with ottoRequestLoad(). */
{
struct ottoRequest *el;

if ((el = *pEl) == NULL) return;
freeMem(el->fromDb);
freeMem(el->toDb);
freeMem(el->email);
freeMem(el->comment);
freeMem(el->requestTime);
freeMem(el->completeTime);
freez(pEl);
}

void ottoRequestFreeList(struct ottoRequest **pList)
/* Free a list of dynamically allocated ottoRequest's */
{
struct ottoRequest *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ottoRequestFree(&el);
    }
*pList = NULL;
}

void ottoRequestOutput(struct ottoRequest *el, FILE *f, char sep, char lastSep)
/* Print out ottoRequest.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fromDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->toDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->email);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->comment);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->requestTime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->doneStatus);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->completeTime);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void ottoRequestJsonOutput(struct ottoRequest *el, FILE *f)
/* Print out ottoRequest in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"id");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->id);
fputc(',',f);
fputc('"',f);
fprintf(f,"fromDb");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->fromDb);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"toDb");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->toDb);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"email");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->email);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"comment");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->comment);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"requestTime");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->requestTime);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"doneStatus");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->doneStatus);
fputc(',',f);
fputc('"',f);
fprintf(f,"completeTime");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->completeTime);
fputc('"',f);
fputc('}',f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

