/* scopDes.c was originally generated by the autoSql program, which also 
 * generated scopDes.h and scopDes.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "scopDes.h"


void scopDesStaticLoad(char **row, struct scopDes *ret)
/* Load a row from scopDes table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->sunid = sqlSigned(row[0]);
strcpy(ret->type, row[1]);
ret->sccs = row[2];
ret->sid = row[3];
ret->description = row[4];
}

struct scopDes *scopDesLoad(char **row)
/* Load a scopDes from row fetched with select * from scopDes
 * from database.  Dispose of this with scopDesFree(). */
{
struct scopDes *ret;

AllocVar(ret);
ret->sunid = sqlSigned(row[0]);
strcpy(ret->type, row[1]);
ret->sccs = cloneString(row[2]);
ret->sid = cloneString(row[3]);
ret->description = cloneString(row[4]);
return ret;
}

struct scopDes *scopDesLoadAll(char *fileName) 
/* Load all scopDes from a whitespace-separated file.
 * Dispose of this with scopDesFreeList(). */
{
struct scopDes *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = scopDesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct scopDes *scopDesLoadAllByChar(char *fileName, char chopper) 
/* Load all scopDes from a chopper separated file.
 * Dispose of this with scopDesFreeList(). */
{
struct scopDes *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = scopDesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct scopDes *scopDesCommaIn(char **pS, struct scopDes *ret)
/* Create a scopDes out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new scopDes */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->sunid = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->type, sizeof(ret->type));
ret->sccs = sqlStringComma(&s);
ret->sid = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void scopDesFree(struct scopDes **pEl)
/* Free a single dynamically allocated scopDes such as created
 * with scopDesLoad(). */
{
struct scopDes *el;

if ((el = *pEl) == NULL) return;
freeMem(el->sccs);
freeMem(el->sid);
freeMem(el->description);
freez(pEl);
}

void scopDesFreeList(struct scopDes **pList)
/* Free a list of dynamically allocated scopDes's */
{
struct scopDes *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    scopDesFree(&el);
    }
*pList = NULL;
}

void scopDesOutput(struct scopDes *el, FILE *f, char sep, char lastSep) 
/* Print out scopDes.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->sunid);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sccs);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

