table clinVarBed
"Browser extensible data (12 fields) plus information about a ClinVar entry. _clinSignCode has these possible values: BN=benign, LB=likely benign, CF=conflicting, PG=pathogenic, LP=likely pathogenic, UC=uncertain, OT=other"
    (
    string chrom;        "Chromosome (or contig, scaffold, etc.)"
    uint   chromStart;   "Start position in chromosome"
    uint   chromEnd;     "End position in chromosome"
    string name;         "Name of item"
    uint   score;      "Score from 0-1000"
    char[1] strand;    "+ or -"
    uint thickStart;   "Start of where display should be thick (start codon)"
    uint thickEnd;     "End of where display should be thick (stop codon)"
    uint reserved;     "Used as itemRgb as of 2004-11-22"
    int blockCount;    "Number of blocks"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"
    lstring origName;         "Link to ClinVar with Variant ID"
    string clinSign;         "Clinical significance"
    string reviewStatus;   "Review Status"
    string type;         "Type of Variant"
    string geneId;         "Gene Symbol"
    string molConseq;         "Molecular Consequence"
    string snpId;         "dbSNP ID"
    string nsvId;         "dbVar ID"
    lstring rcvAcc;         "ClinVar Allele Submission"
    string testedInGtr;         "Genetic Testing Registry"
    lstring phenotypeList;         "Phenotypes"
    lstring phenotype;         "Phenotype identifiers"
    string origin;         "Allele origin"
    string assembly;         "Genome assembly"
    string cytogenetic;         "Cytogenetic status"
    lstring _jsonHgvsTable;         "HGVS names"
    lstring _hgvsProt;         "Protein HGVS"
    string numSubmit;         "Number of submitters"
    string lastEval;         "Last evaluation"
    string guidelines;         "Guidelines"
    lstring otherIds;         "Other identifiers (ClinGen, OMIM, etc.)"
    lstring _mouseOver;        "Mouse over text"
    string vcfDesc;            "VCF position|Can differ from ClinVar position due to left/right shifting rules"
    string somImpactDesc;       "Somatic Impact"
    string oncogenDesc;       "Oncogen"
    lstring aggrGermClass;      "Aggregrate Germline Classification"
    string aggrSomClassImpact;      "Aggregrate Somatic Classification of Clinical Impact"
    string aggrSomClassOnc;      "Aggregate Somatic Classification of Oncogenicity"
    string _clinSignCode;        "Clinical Significance"
    string _originCode;        "Allele Origin Code"
    string _allTypeCode;        "Variation Type"
    uint _varLen;            "Variant Length in base pairs"
    uint _starCount;         "Number of stars"
    int _variantId;           "ClinVar variant ID"
    string _dbVarSsvId;           "dbVar SSV ID"
    string vcvId;            "ClinVar VCV Accession"
    string _vcvIdVersion;            "ClinVar VCV with version"
    string _label;            "Label replacing the name field on hgTracks"
    )
