/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.internal.Iterators;
import com.google.inject.servlet.FilterChainInvocation;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.servlet.UriPatternMatcher;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterDefinition {
    private final String pattern;
    private final Key<? extends Filter> filterKey;
    private final UriPatternMatcher patternMatcher;
    private final Map<String, String> initParams;
    private final AtomicReference<Filter> filter = new AtomicReference();

    public FilterDefinition(String pattern, Key<? extends Filter> filterKey, UriPatternMatcher patternMatcher, Map<String, String> initParams) {
        this.pattern = pattern;
        this.filterKey = filterKey;
        this.patternMatcher = patternMatcher;
        this.initParams = Collections.unmodifiableMap(new HashMap<String, String>(initParams));
    }

    private boolean shouldFilter(String uri) {
        return this.patternMatcher.matches(uri);
    }

    public void init(final ServletContext servletContext, Injector injector, Set<Filter> initializedSoFar) throws ServletException {
        if (!ServletScopes.isSingletonBinding(injector.getBinding(this.filterKey))) {
            throw new ServletException("Filters must be bound as singletons. " + this.filterKey + " was not bound in singleton scope.");
        }
        Filter filter = injector.getInstance(this.filterKey);
        this.filter.set(filter);
        if (initializedSoFar.contains(filter)) {
            return;
        }
        filter.init(new FilterConfig(){

            public String getFilterName() {
                return FilterDefinition.this.filterKey.toString();
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String s) {
                return (String)FilterDefinition.this.initParams.get(s);
            }

            public Enumeration getInitParameterNames() {
                return Iterators.asEnumeration(FilterDefinition.this.initParams.keySet().iterator());
            }
        });
        initializedSoFar.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Set<Filter> destroyedSoFar) {
        Filter reference = this.filter.get();
        if (null == reference || destroyedSoFar.contains(reference)) {
            return;
        }
        try {
            reference.destroy();
        }
        finally {
            destroyedSoFar.add(reference);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChainInvocation filterChainInvocation) throws IOException, ServletException {
        String path = ((HttpServletRequest)servletRequest).getServletPath();
        if (this.shouldFilter(path)) {
            this.filter.get().doFilter(servletRequest, servletResponse, filterChainInvocation);
        } else {
            filterChainInvocation.doFilter(servletRequest, servletResponse);
        }
    }

    Filter getFilter() {
        return this.filter.get();
    }
}

