/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.BrowserPanic;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.protocol.BrowserLog;
import com.google.jstestdriver.protocol.Noop;
import java.lang.reflect.Type;
import java.util.Collection;

public class Response {
    private String type;
    private String response = "";
    private BrowserInfo browser = new BrowserInfo();
    private String error = "";
    private long executionTime = 0L;

    public Response() {
    }

    public Response(String type, String response, BrowserInfo browser, String error, long executionTime) {
        this.type = type;
        this.response = response;
        this.browser = browser;
        this.error = error;
        this.executionTime = executionTime;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public BrowserInfo getBrowser() {
        return this.browser;
    }

    public void setBrowser(BrowserInfo browser) {
        this.browser = browser;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResponseType getResponseType() {
        if (this.type == null) {
            return ResponseType.UNKNOWN;
        }
        return ResponseType.valueOf(this.type);
    }

    public Type getGsonType() {
        return ResponseType.valueOf((String)this.type).type;
    }

    public String toString() {
        return "Response (\nbrowser=[" + this.browser + "], \nerror=[" + this.error + "], \nexecutionTime=[" + this.executionTime + "], \nresponse=[" + this.response + "], \ntype=[" + this.type + "])";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browser == null ? 0 : this.browser.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (int)(this.executionTime ^ this.executionTime >>> 32);
        result = 31 * result + (this.response == null ? 0 : this.response.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Response)) {
            return false;
        }
        Response other = (Response)obj;
        if (this.browser == null ? other.browser != null : !this.browser.equals(other.browser)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (this.executionTime != other.executionTime) {
            return false;
        }
        if (this.response == null ? other.response != null : !this.response.equals(other.response)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseType {
        FILE_LOAD_RESULT((Type)((Object)LoadedFiles.class)),
        REGISTER_RESULT(null),
        TEST_RESULT(new TypeToken<Collection<TestResult>>(){}.getType()),
        TEST_QUERY_RESULT(null),
        RESET_RESULT(null),
        BROWSER_PANIC((Type)((Object)BrowserPanic.class)),
        UNKNOWN(null),
        BROWSER_READY(null),
        COMMAND_RESULT(null),
        NOOP((Type)((Object)Noop.class)),
        LOG((Type)((Object)BrowserLog.class));

        public final Type type;

        private ResponseType(Type type) {
            this.type = type;
        }
    }
}

