/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.debugger;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Time;
import com.google.jstestdriver.hooks.ResourcePreProcessor;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerFileListProcessor
implements ResourcePreProcessor {
    private static final String DEBUGGER_SOURCE = "/* Execution has been paused using the 'debugger' statement.Please set the appropriate break points and resume execution. */\ndebugger;";
    private final Time time;

    @Inject
    public DebuggerFileListProcessor(Time time) {
        this.time = time;
    }

    @Override
    public List<FileInfo> processTests(List<FileInfo> files) {
        LinkedList<FileInfo> processed = Lists.newLinkedList(files);
        processed.add(new FileInfo("debugger.js", this.time.now().getMillis(), -1L, false, false, DEBUGGER_SOURCE, "debugger.js"));
        return processed;
    }

    @Override
    public List<FileInfo> processPlugins(List<FileInfo> files) {
        return files;
    }

    @Override
    public List<FileInfo> processDependencies(List<FileInfo> files) {
        return null;
    }
}

