/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.jstestdriver.SlaveResourceService;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticResourceHandler
implements RequestHandler {
    public static final Map<String, String> MIME_TYPE_MAP = ImmutableMap.builder().put("css", "text/css").put("js", "text/javascript").build();
    private final SlaveResourceService service;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    @Inject
    public StaticResourceHandler(SlaveResourceService service, HttpServletRequest request, HttpServletResponse response) {
        this.service = service;
        this.request = request;
        this.response = response;
    }

    public void handleIt() throws IOException {
        String pathInfo = this.request.getPathInfo();
        String mimeType = MIME_TYPE_MAP.get(pathInfo.substring(pathInfo.lastIndexOf(".") + 1));
        if (mimeType != null) {
            this.response.setContentType(mimeType);
        }
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Cache-Control", "private, no-cache, no-store, max-age=0, must-revalidate");
        this.response.setHeader("Expires", "Sat, 22 Sep 1984 00:00:00 GMT");
        this.service.serve(pathInfo, this.response.getOutputStream());
    }
}

