/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Inject;
import com.google.jstestdriver.coverage.Code;
import com.google.jstestdriver.coverage.CoverageNameMapper;
import com.google.jstestdriver.coverage.InstrumentedCode;
import com.google.jstestdriver.coverage.Instrumentor;
import com.google.jstestdriver.coverage.es3.ES3InstrumentLexer;
import com.google.jstestdriver.coverage.es3.ES3InstrumentParser;
import java.io.CharArrayReader;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.stringtemplate.StringTemplateGroup;

public class CodeInstrumentor
implements Instrumentor {
    private static final char[] TEMPLATE = "group TestRewrite;\ninit_instrument(stmt, hash, name, lines) ::= \"LCOV_<hash>=LCOV.initNoop(<name>,0,<lines>);<stmt>\"instrument(stmt, hash, ln) ::= \"LCOV_<hash>[<ln>]++; <stmt>\"pass(stmt) ::= \"<stmt>\"".toCharArray();
    private final CoverageNameMapper mapper;

    @Inject
    public CodeInstrumentor(CoverageNameMapper mapper) {
        this.mapper = mapper;
    }

    public InstrumentedCode instrument(Code code) {
        String mappedName;
        StringTemplateGroup templates = new StringTemplateGroup(new CharArrayReader(TEMPLATE));
        ANTLRStringStream stream = new ANTLRStringStream(code.getSourceCode());
        Integer fileId = this.mapper.map(code.getFilePath());
        stream.name = mappedName = String.valueOf(fileId);
        ES3InstrumentLexer lexer = new ES3InstrumentLexer(stream);
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        ES3InstrumentParser parser = new ES3InstrumentParser(tokens);
        parser.setTemplateLib(templates);
        try {
            parser.program();
        }
        catch (Exception e) {
            throw new InstrumentationException(code.getFilePath(), e);
        }
        List<Integer> executableLines = parser.linesMap.get(mappedName);
        return new InstrumentedCode(fileId, code.getFilePath(), executableLines == null ? Collections.emptyList() : executableLines, tokens.toString());
    }

    public class InstrumentationException
    extends Error {
        private static final long serialVersionUID = 6999317302885453217L;

        public InstrumentationException(String path, Throwable cause) {
            super("error instrumenting " + path, cause);
        }
    }
}

