---
title: "Genome Browser Tutorials"
---

The UCSC Genome Browser allows scientists to visualize genomic data from a wide variety of sources,
on the genome of their choice. It supports custom annotations, remote-hosted data, and various data
formats. Additional tools include tools to create and share permanent links of Browser snapshots, BLAT
to quickly align genomic sequences, and the Table Browser to interactively extract and browse all hosted data.

## Tutorials

The tutorials below cover some of our most popular tools. Each tutorial includes annotated 
screenshots, a step-by-step walkthrough, and an interactive tutorial.

<div class="row" style="padding-top: 15px">
<div class="col-md-6">
<div class="panel panel-default" style="padding-bottom: 10px">
<h3 class="panel-title" style="width: -webkit-fill-available;"
>Genome Browser 101</h3>

A basic introduction of the most common UCSC Genome Browser usage. This includes 
the navigation menu, configuration of the tracks display, and where to find additional resources. (15 min)

<p style="text-align: end">
<button>[View Tutorial](gb101.html)</button>
</p>
</div>
</div>

<div class="col-md-6">
<div class="panel panel-default" style="padding-bottom: 10px">
<h3 class="panel-title" style="width: -webkit-fill-available;">
    Gateway Page
    <span 
        style="color: red; font-size: smaller; margin-left: 10px; cursor: pointer;" 
        title="Subscribe to our news mailing list to be the first to learn about new tutorials.">
    </span>
</h3>

Learn how best to use the Gateway page to find assemblies and download shortcuts.

<p style="text-align: end">
<button>[View Tutorial](gatewayTutorial.html)</button>
</p>
</div>
</div>
</div>

<div class="row" style="padding-top: 15px">
<div class="col-md-6">
<div class="panel panel-default" style="padding-bottom: 10px">
<h3 class="panel-title" style="width: -webkit-fill-available;">
    Table Browser
    </span>
</h3>

Learn how to extract Genome Browser data sets in various ways.

<p style="text-align: end">
<button>[View Tutorial](tableBrowserTutorial.html)</button>
</p>
</div>
</div>

<div class="col-md-6">
<div class="panel panel-default" style="padding-bottom: 10px">
<h3 class="panel-title" style="width: -webkit-fill-available;">
    Custom Tracks
    </span>
</h3>

Learn how to format and upload your own data to the Genome Browser.

<p style="text-align: end">
<button>[View Tutorial](customTrackTutorial.html)</button>
</p>
</div>
</div>
</div>

</div>
