/* symTest.c was originally generated by the autoSql program, which also 
 * generated symTest.h and symTest.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "output/symTest.h"



char *symTestCommaSepFieldNames = "id,sex,skills";

/* definitions for sex column */
static char *values_sex[] = {"male", "female", NULL};
static struct hash *valhash_sex = NULL;

/* definitions for skills column */
static char *values_skills[] = {"cProg", "javaProg", "pythonProg", "awkProg", NULL};
static struct hash *valhash_skills = NULL;

void symTestStaticLoad(char **row, struct symTest *ret)
/* Load a row from symTest table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->sex = sqlEnumParse(row[1], values_sex, &valhash_sex);
ret->skills = sqlSetParse(row[2], values_skills, &valhash_skills);
}

struct symTest *symTestLoad(char **row)
/* Load a symTest from row fetched with select * from symTest
 * from database.  Dispose of this with symTestFree(). */
{
struct symTest *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->sex = sqlEnumParse(row[1], values_sex, &valhash_sex);
ret->skills = sqlSetParse(row[2], values_skills, &valhash_skills);
return ret;
}

struct symTest *symTestLoadAll(char *fileName) 
/* Load all symTest from a whitespace-separated file.
 * Dispose of this with symTestFreeList(). */
{
struct symTest *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = symTestLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct symTest *symTestLoadAllByChar(char *fileName, char chopper) 
/* Load all symTest from a chopper separated file.
 * Dispose of this with symTestFreeList(). */
{
struct symTest *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = symTestLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct symTest *symTestCommaIn(char **pS, struct symTest *ret)
/* Create a symTest out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new symTest */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->sex = sqlEnumComma(&s, values_sex, &valhash_sex);
ret->skills = sqlSetComma(&s, values_skills, &valhash_skills);
*pS = s;
return ret;
}

void symTestFree(struct symTest **pEl)
/* Free a single dynamically allocated symTest such as created
 * with symTestLoad(). */
{
struct symTest *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void symTestFreeList(struct symTest **pList)
/* Free a list of dynamically allocated symTest's */
{
struct symTest *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    symTestFree(&el);
    }
*pList = NULL;
}

void symTestOutput(struct symTest *el, FILE *f, char sep, char lastSep) 
/* Print out symTest.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->sex, values_sex);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlSetPrint(f, el->skills, values_skills);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

