/* bdgpSwissProt.h was originally generated by the autoSql program, which also 
 * generated bdgpSwissProt.c and bdgpSwissProt.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2003 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef BDGPSWISSPROT_H
#define BDGPSWISSPROT_H

#define BDGPSWISSPROT_NUM_COLS 8

struct bdgpSwissProt
/* Berkeley Drosophile Genome Project Protein-Coding Genes track additional information plus SwissProt acc & desc */
    {
    struct bdgpSwissProt *next;  /* Next in singly linked list. */
    char *bdgpName;	/* BDGP annotation gene name */
    char *flyBaseId;	/* FlyBase FBgn ID */
    char *go;	/* comma-sep list of GO numeric IDs */
    char *symbol;	/* symbolic gene name */
    char *cytorange;	/* cytorange */
    char *swissProtId;	/* SwissProt ID */
    char *spGeneName;	/* (long) gene name from SwissProt */
    char *spSymbol;	/* symbolic-looking gene id from SwissProt */
    };

void bdgpSwissProtStaticLoad(char **row, struct bdgpSwissProt *ret);
/* Load a row from bdgpSwissProt table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bdgpSwissProt *bdgpSwissProtLoad(char **row);
/* Load a bdgpSwissProt from row fetched with select * from bdgpSwissProt
 * from database.  Dispose of this with bdgpSwissProtFree(). */

struct bdgpSwissProt *bdgpSwissProtLoadAll(char *fileName);
/* Load all bdgpSwissProt from whitespace-separated file.
 * Dispose of this with bdgpSwissProtFreeList(). */

struct bdgpSwissProt *bdgpSwissProtLoadAllByChar(char *fileName, char chopper);
/* Load all bdgpSwissProt from chopper separated file.
 * Dispose of this with bdgpSwissProtFreeList(). */

#define bdgpSwissProtLoadAllByTab(a) bdgpSwissProtLoadAllByChar(a, '\t');
/* Load all bdgpSwissProt from tab separated file.
 * Dispose of this with bdgpSwissProtFreeList(). */

struct bdgpSwissProt *bdgpSwissProtCommaIn(char **pS, struct bdgpSwissProt *ret);
/* Create a bdgpSwissProt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bdgpSwissProt */

void bdgpSwissProtFree(struct bdgpSwissProt **pEl);
/* Free a single dynamically allocated bdgpSwissProt such as created
 * with bdgpSwissProtLoad(). */

void bdgpSwissProtFreeList(struct bdgpSwissProt **pList);
/* Free a list of dynamically allocated bdgpSwissProt's */

void bdgpSwissProtOutput(struct bdgpSwissProt *el, FILE *f, char sep, char lastSep);
/* Print out bdgpSwissProt.  Separate fields with sep. Follow last field with lastSep. */

#define bdgpSwissProtTabOut(el,f) bdgpSwissProtOutput(el,f,'\t','\n');
/* Print out bdgpSwissProt as a line in a tab-separated file. */

#define bdgpSwissProtCommaOut(el,f) bdgpSwissProtOutput(el,f,',',',');
/* Print out bdgpSwissProt as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BDGPSWISSPROT_H */

