/* ccdsNotes.h was originally generated by the autoSql program, which also 
 * generated ccdsNotes.c and ccdsNotes.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2010 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CCDSNOTES_H
#define CCDSNOTES_H

#define CCDSNOTES_NUM_COLS 3

struct ccdsNotes
/* Consensus CDS public notes */
    {
    struct ccdsNotes *next;  /* Next in singly linked list. */
    char ccds[13];	/* CCDS id */
    char createDate[11];	/* date note was added */
    char *note;	/* text of note */
    };

void ccdsNotesStaticLoad(char **row, struct ccdsNotes *ret);
/* Load a row from ccdsNotes table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ccdsNotes *ccdsNotesLoad(char **row);
/* Load a ccdsNotes from row fetched with select * from ccdsNotes
 * from database.  Dispose of this with ccdsNotesFree(). */

struct ccdsNotes *ccdsNotesLoadAll(char *fileName);
/* Load all ccdsNotes from whitespace-separated file.
 * Dispose of this with ccdsNotesFreeList(). */

struct ccdsNotes *ccdsNotesLoadAllByChar(char *fileName, char chopper);
/* Load all ccdsNotes from chopper separated file.
 * Dispose of this with ccdsNotesFreeList(). */

#define ccdsNotesLoadAllByTab(a) ccdsNotesLoadAllByChar(a, '\t');
/* Load all ccdsNotes from tab separated file.
 * Dispose of this with ccdsNotesFreeList(). */

struct ccdsNotes *ccdsNotesCommaIn(char **pS, struct ccdsNotes *ret);
/* Create a ccdsNotes out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ccdsNotes */

void ccdsNotesFree(struct ccdsNotes **pEl);
/* Free a single dynamically allocated ccdsNotes such as created
 * with ccdsNotesLoad(). */

void ccdsNotesFreeList(struct ccdsNotes **pList);
/* Free a list of dynamically allocated ccdsNotes's */

void ccdsNotesOutput(struct ccdsNotes *el, FILE *f, char sep, char lastSep);
/* Print out ccdsNotes.  Separate fields with sep. Follow last field with lastSep. */

#define ccdsNotesTabOut(el,f) ccdsNotesOutput(el,f,'\t','\n');
/* Print out ccdsNotes as a line in a tab-separated file. */

#define ccdsNotesCommaOut(el,f) ccdsNotesOutput(el,f,',',',');
/* Print out ccdsNotes as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

char *ccdsNotesGetCreateSql(char *table);
/* Get sql command to create ccdsNotes table. Result should be freed. */

#endif /* CCDSNOTES_H */

