/* cpgIslandExt.h was originally generated by the autoSql program, which also 
 * generated cpgIslandExt.c and cpgIslandExt.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CPGISLANDEXT_H
#define CPGISLANDEXT_H

#define CPGISLANDEXT_NUM_COLS 10

struct cpgIslandExt
/* Describes the CpG Islands (includes observed/expected ratio) */
    {
    struct cpgIslandExt *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome or FPC contig */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* CpG Island */
    unsigned length;	/* Island Length */
    unsigned cpgNum;	/* Number of CpGs in island */
    unsigned gcNum;	/* Number of C and G in island */
    float perCpg;	/* Percentage of island that is CpG */
    float perGc;	/* Percentage of island that is C or G */
    float obsExp;	/* Ratio of observed(cpgNum) to expected(numC*numG/length) CpG in island */
    };

void cpgIslandExtStaticLoad(char **row, struct cpgIslandExt *ret);
/* Load a row from cpgIslandExt table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cpgIslandExt *cpgIslandExtLoad(char **row);
/* Load a cpgIslandExt from row fetched with select * from cpgIslandExt
 * from database.  Dispose of this with cpgIslandExtFree(). */

struct cpgIslandExt *cpgIslandExtLoadAll(char *fileName);
/* Load all cpgIslandExt from whitespace-separated file.
 * Dispose of this with cpgIslandExtFreeList(). */

struct cpgIslandExt *cpgIslandExtLoadAllByChar(char *fileName, char chopper);
/* Load all cpgIslandExt from chopper separated file.
 * Dispose of this with cpgIslandExtFreeList(). */

#define cpgIslandExtLoadAllByTab(a) cpgIslandExtLoadAllByChar(a, '\t');
/* Load all cpgIslandExt from tab separated file.
 * Dispose of this with cpgIslandExtFreeList(). */

struct cpgIslandExt *cpgIslandExtCommaIn(char **pS, struct cpgIslandExt *ret);
/* Create a cpgIslandExt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cpgIslandExt */

void cpgIslandExtFree(struct cpgIslandExt **pEl);
/* Free a single dynamically allocated cpgIslandExt such as created
 * with cpgIslandExtLoad(). */

void cpgIslandExtFreeList(struct cpgIslandExt **pList);
/* Free a list of dynamically allocated cpgIslandExt's */

void cpgIslandExtOutput(struct cpgIslandExt *el, FILE *f, char sep, char lastSep);
/* Print out cpgIslandExt.  Separate fields with sep. Follow last field with lastSep. */

#define cpgIslandExtTabOut(el,f) cpgIslandExtOutput(el,f,'\t','\n');
/* Print out cpgIslandExt as a line in a tab-separated file. */

#define cpgIslandExtCommaOut(el,f) cpgIslandExtOutput(el,f,',',',');
/* Print out cpgIslandExt as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CPGISLANDEXT_H */

