/* ctgPos2.h was originally generated by the autoSql program, which also 
 * generated ctgPos2.c and ctgPos2.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CTGPOS2_H
#define CTGPOS2_H

#define CTGPOS2_NUM_COLS 6

struct ctgPos2
/* Where a contig is inside of a chromosome including contig type information. */
    {
    struct ctgPos2 *next;  /* Next in singly linked list. */
    char *contig;	/* Name of contig */
    unsigned size;	/* Size of contig */
    char *chrom;	/* Chromosome name */
    unsigned chromStart;	/* Start in chromosome */
    unsigned chromEnd;	/* End in chromosome */
    char type[2];	/* (W)GS contig, (F)inished, (P)redraft, (D)raft, (O)ther */
    };

void ctgPos2StaticLoad(char **row, struct ctgPos2 *ret);
/* Load a row from ctgPos2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ctgPos2 *ctgPos2Load(char **row);
/* Load a ctgPos2 from row fetched with select * from ctgPos2
 * from database.  Dispose of this with ctgPos2Free(). */

struct ctgPos2 *ctgPos2LoadAll(char *fileName);
/* Load all ctgPos2 from whitespace-separated file.
 * Dispose of this with ctgPos2FreeList(). */

struct ctgPos2 *ctgPos2LoadAllByChar(char *fileName, char chopper);
/* Load all ctgPos2 from chopper separated file.
 * Dispose of this with ctgPos2FreeList(). */

#define ctgPos2LoadAllByTab(a) ctgPos2LoadAllByChar(a, '\t');
/* Load all ctgPos2 from tab separated file.
 * Dispose of this with ctgPos2FreeList(). */

struct ctgPos2 *ctgPos2CommaIn(char **pS, struct ctgPos2 *ret);
/* Create a ctgPos2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ctgPos2 */

void ctgPos2Free(struct ctgPos2 **pEl);
/* Free a single dynamically allocated ctgPos2 such as created
 * with ctgPos2Load(). */

void ctgPos2FreeList(struct ctgPos2 **pList);
/* Free a list of dynamically allocated ctgPos2's */

void ctgPos2Output(struct ctgPos2 *el, FILE *f, char sep, char lastSep);
/* Print out ctgPos2.  Separate fields with sep. Follow last field with lastSep. */

#define ctgPos2TabOut(el,f) ctgPos2Output(el,f,'\t','\n');
/* Print out ctgPos2 as a line in a tab-separated file. */

#define ctgPos2CommaOut(el,f) ctgPos2Output(el,f,',',',');
/* Print out ctgPos2 as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CTGPOS2_H */

