/* geneTree.h was originally generated by the autoSql program, which also 
 * generated geneTree.c and geneTree.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2010 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef GENETREE_H
#define GENETREE_H

#define GENETREE_NUM_COLS 2

struct geneTree
/* A tree that represents the phylogenetic relation between a gene and its orthologs. */
    {
    struct geneTree *next;  /* Next in singly linked list. */
    char *name;	/* Name of gene */
    char *tree;	/* Newick format of phylogenetic tree */
    };

void geneTreeStaticLoad(char **row, struct geneTree *ret);
/* Load a row from geneTree table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct geneTree *geneTreeLoad(char **row);
/* Load a geneTree from row fetched with select * from geneTree
 * from database.  Dispose of this with geneTreeFree(). */

struct geneTree *geneTreeLoadAll(char *fileName);
/* Load all geneTree from whitespace-separated file.
 * Dispose of this with geneTreeFreeList(). */

struct geneTree *geneTreeLoadAllByChar(char *fileName, char chopper);
/* Load all geneTree from chopper separated file.
 * Dispose of this with geneTreeFreeList(). */

#define geneTreeLoadAllByTab(a) geneTreeLoadAllByChar(a, '\t');
/* Load all geneTree from tab separated file.
 * Dispose of this with geneTreeFreeList(). */

struct geneTree *geneTreeCommaIn(char **pS, struct geneTree *ret);
/* Create a geneTree out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneTree */

void geneTreeFree(struct geneTree **pEl);
/* Free a single dynamically allocated geneTree such as created
 * with geneTreeLoad(). */

void geneTreeFreeList(struct geneTree **pList);
/* Free a list of dynamically allocated geneTree's */

void geneTreeOutput(struct geneTree *el, FILE *f, char sep, char lastSep);
/* Print out geneTree.  Separate fields with sep. Follow last field with lastSep. */

#define geneTreeTabOut(el,f) geneTreeOutput(el,f,'\t','\n');
/* Print out geneTree as a line in a tab-separated file. */

#define geneTreeCommaOut(el,f) geneTreeOutput(el,f,',',',');
/* Print out geneTree as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GENETREE_H */

