/* refSeqStatus.h was originally generated by the autoSql program, which also 
 * generated refSeqStatus.c and refSeqStatus.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2009 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef REFSEQSTATUS_H
#define REFSEQSTATUS_H

#define REFSEQSTATUS_NUM_COLS 3

enum refSeqStatusStatus
    {
    refSeqStatusUnknown = 0,
    refSeqStatusReviewed = 1,
    refSeqStatusValidated = 2,
    refSeqStatusProvisional = 3,
    refSeqStatusPredicted = 4,
    refSeqStatusInferred = 5,
    };
enum refSeqStatusMol
    {
    refSeqStatusDNA = 0,
    refSeqStatusRNA = 1,
    refSeqStatusDs_RNA = 2,
    refSeqStatusDs_mRNA = 3,
    refSeqStatusDs_rRNA = 4,
    refSeqStatusMRNA = 5,
    refSeqStatusMs_DNA = 6,
    refSeqStatusMs_RNA = 7,
    refSeqStatusRRNA = 8,
    refSeqStatusScRNA = 9,
    refSeqStatusSnRNA = 10,
    refSeqStatusSnoRNA = 11,
    refSeqStatusSs_DNA = 12,
    refSeqStatusSs_RNA = 13,
    refSeqStatusSs_snoRNA = 14,
    refSeqStatusTRNA = 15,
    };
struct refSeqStatus
/* RefSeq Gene Status. */
    {
    struct refSeqStatus *next;  /* Next in singly linked list. */
    char *mrnaAcc;	/* RefSeq gene accession name */
    enum refSeqStatusStatus status;	/* Status of RefSeq */
    enum refSeqStatusMol mol;	/* molecule type */
    };

void refSeqStatusStaticLoad(char **row, struct refSeqStatus *ret);
/* Load a row from refSeqStatus table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct refSeqStatus *refSeqStatusLoad(char **row);
/* Load a refSeqStatus from row fetched with select * from refSeqStatus
 * from database.  Dispose of this with refSeqStatusFree(). */

struct refSeqStatus *refSeqStatusLoadAll(char *fileName);
/* Load all refSeqStatus from whitespace-separated file.
 * Dispose of this with refSeqStatusFreeList(). */

struct refSeqStatus *refSeqStatusLoadAllByChar(char *fileName, char chopper);
/* Load all refSeqStatus from chopper separated file.
 * Dispose of this with refSeqStatusFreeList(). */

#define refSeqStatusLoadAllByTab(a) refSeqStatusLoadAllByChar(a, '\t');
/* Load all refSeqStatus from tab separated file.
 * Dispose of this with refSeqStatusFreeList(). */

struct refSeqStatus *refSeqStatusCommaIn(char **pS, struct refSeqStatus *ret);
/* Create a refSeqStatus out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new refSeqStatus */

void refSeqStatusFree(struct refSeqStatus **pEl);
/* Free a single dynamically allocated refSeqStatus such as created
 * with refSeqStatusLoad(). */

void refSeqStatusFreeList(struct refSeqStatus **pList);
/* Free a list of dynamically allocated refSeqStatus's */

void refSeqStatusOutput(struct refSeqStatus *el, FILE *f, char sep, char lastSep);
/* Print out refSeqStatus.  Separate fields with sep. Follow last field with lastSep. */

#define refSeqStatusTabOut(el,f) refSeqStatusOutput(el,f,'\t','\n');
/* Print out refSeqStatus as a line in a tab-separated file. */

#define refSeqStatusCommaOut(el,f) refSeqStatusOutput(el,f,',',',');
/* Print out refSeqStatus as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* REFSEQSTATUS_H */

