# bgiSnp.sql was originally generated by the autoSql program, which also 
# generated bgiSnp.c and bgiSnp.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Beijing Genomics Institute SNP information as bed 4 +
CREATE TABLE bgiSnp (
    bin smallint unsigned not null,	# bin for speed
    chrom varchar(255) not null,	# Chromosome
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# BGI SNP name: snp.superctg.ctg.pos.type.strainID
    snpType char(1) not null,	# S (substitution), I (insertion), or D (deletion)
    readStart int unsigned not null,	# Start position in alternate allele read
    readEnd int unsigned not null,	# End position in alternate allele read
    qualChr int unsigned not null,	# Quality score in reference assembly
    qualReads int unsigned not null,	# Quality score in alternate allele read
    snpSeq varchar(255) not null,	# 'X->Y' or indel sequence
    readName varchar(255) not null,	# Name of alternate allele read
    readDir char(1) not null,	# Direction of read relative to reference
    inBroiler char(4) not null,	# SNP found in Broiler strain? yes, no or n/a if not covered
    inLayer char(4) not null,	# SNP found in Layer strain? yes, no or n/a if not covered
    inSilkie char(4) not null,	# SNP found in Silkie strain? yes, no or n/a if not covered
    primerL varchar(255) not null,	# Left primer sequence
    primerR varchar(255) not null,	# Right primer sequence
    questionM char(1) not null,	# L for dubious indels, H for other indels and SNPs
    extra varchar(255) not null,	# Additional information
              #Indices
    INDEX(chrom(12),bin),
    INDEX(name(18))
);
