/* bigChain.c was originally generated by the autoSql program, which also 
 * generated bigChain.h and bigChain.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bigChain.h"



char *bigChainCommaSepFieldNames = "chrom,chromStart,chromEnd,name,score,strand,tSize,qName,qSize,qStart,qEnd,chainScore";

void bigChainStaticLoad(char **row, struct bigChain *ret)
/* Load a row from bigChain table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->tSize = sqlUnsigned(row[6]);
ret->qName = row[7];
ret->qSize = sqlUnsigned(row[8]);
ret->qStart = sqlUnsigned(row[9]);
ret->qEnd = sqlUnsigned(row[10]);
ret->chainScore = sqlDouble(row[11]);
}

struct bigChain *bigChainLoad(char **row)
/* Load a bigChain from row fetched with select * from bigChain
 * from database.  Dispose of this with bigChainFree(). */
{
struct bigChain *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->tSize = sqlUnsigned(row[6]);
ret->qName = cloneString(row[7]);
ret->qSize = sqlUnsigned(row[8]);
ret->qStart = sqlUnsigned(row[9]);
ret->qEnd = sqlUnsigned(row[10]);
ret->chainScore = sqlDouble(row[11]);
return ret;
}

struct bigChain *bigChainLoadAll(char *fileName) 
/* Load all bigChain from a whitespace-separated file.
 * Dispose of this with bigChainFreeList(). */
{
struct bigChain *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = bigChainLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigChain *bigChainLoadAllByChar(char *fileName, char chopper) 
/* Load all bigChain from a chopper separated file.
 * Dispose of this with bigChainFreeList(). */
{
struct bigChain *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bigChainLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bigChain *bigChainCommaIn(char **pS, struct bigChain *ret)
/* Create a bigChain out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigChain */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->tSize = sqlUnsignedComma(&s);
ret->qName = sqlStringComma(&s);
ret->qSize = sqlUnsignedComma(&s);
ret->qStart = sqlUnsignedComma(&s);
ret->qEnd = sqlUnsignedComma(&s);
ret->chainScore = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void bigChainFree(struct bigChain **pEl)
/* Free a single dynamically allocated bigChain such as created
 * with bigChainLoad(). */
{
struct bigChain *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->qName);
freez(pEl);
}

void bigChainFreeList(struct bigChain **pList)
/* Free a list of dynamically allocated bigChain's */
{
struct bigChain *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bigChainFree(&el);
    }
*pList = NULL;
}

void bigChainOutput(struct bigChain *el, FILE *f, char sep, char lastSep) 
/* Print out bigChain.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->tSize);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->qSize);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(sep,f);
fprintf(f, "%u", el->qEnd);
fputc(sep,f);
fprintf(f, "%g", el->chainScore);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */


int bigChainCmpTarget(const void *va, const void *vb)
/* Compare to sort based on target position. */
{
const struct bigChain *a = *((struct bigChain **)va);
const struct bigChain *b = *((struct bigChain **)vb);
int dif = strcmp(a->chrom, b->chrom);
if (dif == 0)
    dif = a->chromStart - b->chromStart;
return dif;
}

char *bigChainGetLinkFile(char *chainBigBedName)
/* Construct the file name of the chain link file from the name of a chain file. 
 * That is, change file.bb to file.link.bb */
{
char linkBuffer[4096];

if (!endsWith(chainBigBedName, ".bb"))
    errAbort("chain bigBed file (%s) must end in .bb", chainBigBedName);

safef(linkBuffer, sizeof linkBuffer, "%s", chainBigBedName);

// truncate string at ending ".bb"
int insertOffset = strlen(linkBuffer) - sizeof ".bb" + 1;
char *insert = &linkBuffer[insertOffset];
*insert = 0;

// add .link.bb
strcpy(insert, ".link.bb");

return cloneString(linkBuffer);
}
