table dbNsfpPolyPhen2
"PolyPhen2 scores provided by dbNSFP (http://dbnsfp.houstonbioinformatics.org/)"
    (
    string chrom;      "Reference sequence chromosome or scaffold"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    enum('A','C','G','T') refAl;       "Allele found in reference assembly"
    string uniProtAaPos;               "Offset of changed amino acid (1-based) in UniProt sequence; can be comma-sep'd list parallel to UniProt IDs in dbNsfpUniProt"
    enum('A','C','G','T') altAl1;  "alternate allele #1"
    string hDivScore1;                 "Probability score for altAl1 from HumDiv training set, or '.' if n/a"
    enum('D','P','B','.') hDivPred1;   "Prediction for altAl1 from HumDiv: Damaging, Possibly damaging, Benign, not given"
    string hVarScore1;                 "Probability score for altAl1 from HumVar training set, or '.' if n/a"
    enum('D','P','B','.') hVarPred1;   "Prediction for altAl1 from HumVar: Damaging, Possibly damaging, Benign, not given"
    enum('A','C','G','T','.') altAl2;  "alternate allele #2"
    string hDivScore2;                 "Probability score for altAl2 from HumDiv training set, or '.' if n/a"
    enum('D','P','B','.') hDivPred2;   "Prediction for altAl2 from HumDiv: Damaging, Possibly damaging, Benign, not given"
    string hVarScore2;                 "Probability score for altAl2 from HumVar training set, or '.' if n/a"
    enum('D','P','B','.') hVarPred2;   "Prediction for altAl2 from HumVar: Damaging, Possibly damaging, Benign, not given"
    enum('A','C','G','T','.') altAl3;  "alternate allele #3"
    string hDivScore3;                 "Probability score for altAl3 from HumDiv training set, or '.' if n/a"
    enum('D','P','B','.') hDivPred3;   "Prediction for altAl3 from HumDiv: Damaging, Possibly damaging, Benign, not given"
    string hVarScore3;                 "Probability score for altAl3 from HumVar training set, or '.' if n/a"
    enum('D','P','B','.') hVarPred3;   "Prediction for altAl3 from HumVar: Damaging, Possibly damaging, Benign, not given"
    )
