/* wgEncodeGencodePolyAFeature.c was originally generated by the autoSql program, which also 
 * generated wgEncodeGencodePolyAFeature.h and wgEncodeGencodePolyAFeature.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "encode/wgEncodeGencodePolyAFeature.h"


/* definitions for feature column */
static char *values_feature[] = {"polyA_signal", "polyA_site", "pseudo_polyA", NULL};
static struct hash *valhash_feature = NULL;

void wgEncodeGencodePolyAFeatureStaticLoad(char **row, struct wgEncodeGencodePolyAFeature *ret)
/* Load a row from wgEncodeGencodePolyAFeature table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->transcriptId = row[0];
ret->transcriptStart = sqlSigned(row[1]);
ret->transcriptEnd = sqlSigned(row[2]);
ret->chrom = row[3];
ret->chromStart = sqlSigned(row[4]);
ret->endStart = sqlSigned(row[5]);
ret->strand = row[6][0];
ret->feature = sqlEnumParse(row[7], values_feature, &valhash_feature);
}

struct wgEncodeGencodePolyAFeature *wgEncodeGencodePolyAFeatureLoad(char **row)
/* Load a wgEncodeGencodePolyAFeature from row fetched with select * from wgEncodeGencodePolyAFeature
 * from database.  Dispose of this with wgEncodeGencodePolyAFeatureFree(). */
{
struct wgEncodeGencodePolyAFeature *ret;

AllocVar(ret);
ret->transcriptId = cloneString(row[0]);
ret->transcriptStart = sqlSigned(row[1]);
ret->transcriptEnd = sqlSigned(row[2]);
ret->chrom = cloneString(row[3]);
ret->chromStart = sqlSigned(row[4]);
ret->endStart = sqlSigned(row[5]);
ret->strand = row[6][0];
ret->feature = sqlEnumParse(row[7], values_feature, &valhash_feature);
return ret;
}

struct wgEncodeGencodePolyAFeature *wgEncodeGencodePolyAFeatureLoadAll(char *fileName) 
/* Load all wgEncodeGencodePolyAFeature from a whitespace-separated file.
 * Dispose of this with wgEncodeGencodePolyAFeatureFreeList(). */
{
struct wgEncodeGencodePolyAFeature *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = wgEncodeGencodePolyAFeatureLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgEncodeGencodePolyAFeature *wgEncodeGencodePolyAFeatureLoadAllByChar(char *fileName, char chopper) 
/* Load all wgEncodeGencodePolyAFeature from a chopper separated file.
 * Dispose of this with wgEncodeGencodePolyAFeatureFreeList(). */
{
struct wgEncodeGencodePolyAFeature *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = wgEncodeGencodePolyAFeatureLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgEncodeGencodePolyAFeature *wgEncodeGencodePolyAFeatureCommaIn(char **pS, struct wgEncodeGencodePolyAFeature *ret)
/* Create a wgEncodeGencodePolyAFeature out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new wgEncodeGencodePolyAFeature */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->transcriptId = sqlStringComma(&s);
ret->transcriptStart = sqlSignedComma(&s);
ret->transcriptEnd = sqlSignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlSignedComma(&s);
ret->endStart = sqlSignedComma(&s);
sqlFixedStringComma(&s, &(ret->strand), sizeof(ret->strand));
ret->feature = sqlEnumComma(&s, values_feature, &valhash_feature);
*pS = s;
return ret;
}

void wgEncodeGencodePolyAFeatureFree(struct wgEncodeGencodePolyAFeature **pEl)
/* Free a single dynamically allocated wgEncodeGencodePolyAFeature such as created
 * with wgEncodeGencodePolyAFeatureLoad(). */
{
struct wgEncodeGencodePolyAFeature *el;

if ((el = *pEl) == NULL) return;
freeMem(el->transcriptId);
freeMem(el->chrom);
freez(pEl);
}

void wgEncodeGencodePolyAFeatureFreeList(struct wgEncodeGencodePolyAFeature **pList)
/* Free a list of dynamically allocated wgEncodeGencodePolyAFeature's */
{
struct wgEncodeGencodePolyAFeature *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    wgEncodeGencodePolyAFeatureFree(&el);
    }
*pList = NULL;
}

void wgEncodeGencodePolyAFeatureOutput(struct wgEncodeGencodePolyAFeature *el, FILE *f, char sep, char lastSep) 
/* Print out wgEncodeGencodePolyAFeature.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->transcriptId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->transcriptStart);
fputc(sep,f);
fprintf(f, "%d", el->transcriptEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->chromStart);
fputc(sep,f);
fprintf(f, "%d", el->endStart);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->feature, values_feature);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

