/* gtexInfo.c was originally generated by the autoSql program, which also 
 * generated gtexInfo.h and gtexInfo.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gtexInfo.h"
#include "gtexGeneBed.h"



char *gtexInfoCommaSepFieldNames = "version,releaseDate,maxScore,maxMedianScore";

void gtexInfoStaticLoad(char **row, struct gtexInfo *ret)
/* Load a row from gtexInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->version = row[0];
ret->releaseDate = row[1];
ret->maxScore = sqlDouble(row[2]);
ret->maxMedianScore = sqlDouble(row[3]);
}

struct gtexInfo *gtexInfoLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all gtexInfo from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gtexInfoFreeList(). */
{
struct gtexInfo *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = gtexInfoLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void gtexInfoSaveToDb(struct sqlConnection *conn, struct gtexInfo *el, char *tableName, int updateSize)
/* Save gtexInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s',%g,%g)", 
	tableName,  el->version,  el->releaseDate,  el->maxScore,  el->maxMedianScore);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct gtexInfo *gtexInfoLoad(char **row)
/* Load a gtexInfo from row fetched with select * from gtexInfo
 * from database.  Dispose of this with gtexInfoFree(). */
{
struct gtexInfo *ret;

AllocVar(ret);
ret->version = cloneString(row[0]);
ret->releaseDate = cloneString(row[1]);
ret->maxScore = sqlDouble(row[2]);
ret->maxMedianScore = sqlDouble(row[3]);
return ret;
}

struct gtexInfo *gtexInfoLoadAll(char *fileName) 
/* Load all gtexInfo from a whitespace-separated file.
 * Dispose of this with gtexInfoFreeList(). */
{
struct gtexInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = gtexInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexInfo *gtexInfoLoadAllByChar(char *fileName, char chopper) 
/* Load all gtexInfo from a chopper separated file.
 * Dispose of this with gtexInfoFreeList(). */
{
struct gtexInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gtexInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexInfo *gtexInfoCommaIn(char **pS, struct gtexInfo *ret)
/* Create a gtexInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexInfo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->version = sqlStringComma(&s);
ret->releaseDate = sqlStringComma(&s);
ret->maxScore = sqlDoubleComma(&s);
ret->maxMedianScore = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void gtexInfoFree(struct gtexInfo **pEl)
/* Free a single dynamically allocated gtexInfo such as created
 * with gtexInfoLoad(). */
{
struct gtexInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->version);
freeMem(el->releaseDate);
freez(pEl);
}

void gtexInfoFreeList(struct gtexInfo **pList)
/* Free a list of dynamically allocated gtexInfo's */
{
struct gtexInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gtexInfoFree(&el);
    }
*pList = NULL;
}

void gtexInfoOutput(struct gtexInfo *el, FILE *f, char sep, char lastSep) 
/* Print out gtexInfo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->version);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->releaseDate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->maxScore);
fputc(sep,f);
fprintf(f, "%g", el->maxMedianScore);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */


void gtexInfoCreateTable(struct sqlConnection *conn, char *table)
/* Create GTEx info table */
{
char query[1024];

sqlSafef(query, sizeof(query),
"CREATE TABLE %s (\n"
"    version varchar(255) not null,	# GTEX data release (e.g. V4, V6)\n"
"    releaseDate varchar(255) not null,	# Release date\n"
"    maxScore double not null,	# Maximum score observed (use to scale display)\n"
"    maxMedianScore double not null,	# Maximum score observed for a tissue median (use to scale display)\n"
"        #Indices\n"
"    PRIMARY KEY(version)\n"
")\n",   table);
sqlRemakeTable(conn, table, query);
}

char *gtexVersionSuffix(char *table)
/* Return version string for a GTEx track table.  Supporting V4, V6, V8 (default, no suffix )*/                                        
{
if (table)
    {
    if (endsWith(table, "V4"))
        return("V4");
/* 
    TODO: Handle default case more generically
    
    if (endsWith(table, "V6"))
        return("V6");
*/
    if (endsWith(table, "V8"))
        return("V8");
    }
return("");
}

char *gtexVersion(char *table)
/* Return version string based on table suffix. Default version tables have no suffix */
{
char *suffix = gtexVersionSuffix(table);
return (sameString(suffix, "")) ? GTEX_DEFAULT_VERSION : suffix;
}

char *gtexVersionSuffixFromVersion(char *version)
/* Return version table suffix for a version */
{
if (!version)
    version = GTEX_DEFAULT_VERSION;
return (sameString(version, GTEX_DEFAULT_VERSION)) ? "" : version;
}

double gtexMaxMedianScore(char *version)
/* Retrieve max median score for latest (or named) version */
{
char query[1024];
struct sqlConnection *conn = hAllocConn("hgFixed");
if (!conn)
    return 0;
if (!version || sameString(version, ""))
    version = GTEX_DEFAULT_VERSION;
sqlSafef(query, sizeof query, "select maxMedianScore from gtexInfo where version='%s'", version);
double score = sqlQuickDouble(conn, query);
if (score == 0.0)
    errAbort("Internal error: GTEx version \"%s\" not found in gtexInfo table", version);
hFreeConn(&conn);
return score;
}

char *gtexExprUnit(char *version)
/* Units of gene expression */
{
return (sameString(version, "V8") ? "TPM" : "RPKM");
}
