/* gtexSample.c was originally generated by the autoSql program, which also 
 * generated gtexSample.h and gtexSample.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gtexSample.h"



char *gtexSampleCommaSepFieldNames = "sampleId,tissue,donor,autolysisScore,ischemicTime,rin,collectionSites,batchId,isolationType,isolationDate,pathNotes";

void gtexSampleStaticLoad(char **row, struct gtexSample *ret)
/* Load a row from gtexSample table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->sampleId = row[0];
ret->tissue = row[1];
ret->donor = row[2];
ret->autolysisScore = sqlSigned(row[3]);
ret->ischemicTime = row[4];
ret->rin = sqlFloat(row[5]);
ret->collectionSites = row[6];
ret->batchId = row[7];
ret->isolationType = row[8];
ret->isolationDate = row[9];
ret->pathNotes = row[10];
}

struct gtexSample *gtexSampleLoad(char **row)
/* Load a gtexSample from row fetched with select * from gtexSample
 * from database.  Dispose of this with gtexSampleFree(). */
{
struct gtexSample *ret;

AllocVar(ret);
ret->sampleId = cloneString(row[0]);
ret->tissue = cloneString(row[1]);
ret->donor = cloneString(row[2]);
ret->autolysisScore = sqlSigned(row[3]);
ret->ischemicTime = cloneString(row[4]);
ret->rin = sqlFloat(row[5]);
ret->collectionSites = cloneString(row[6]);
ret->batchId = cloneString(row[7]);
ret->isolationType = cloneString(row[8]);
ret->isolationDate = cloneString(row[9]);
ret->pathNotes = cloneString(row[10]);
return ret;
}

struct gtexSample *gtexSampleLoadAll(char *fileName) 
/* Load all gtexSample from a whitespace-separated file.
 * Dispose of this with gtexSampleFreeList(). */
{
struct gtexSample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileRow(lf, row))
    {
    el = gtexSampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexSample *gtexSampleLoadAllByChar(char *fileName, char chopper) 
/* Load all gtexSample from a chopper separated file.
 * Dispose of this with gtexSampleFreeList(). */
{
struct gtexSample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gtexSampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexSample *gtexSampleCommaIn(char **pS, struct gtexSample *ret)
/* Create a gtexSample out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexSample */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->sampleId = sqlStringComma(&s);
ret->tissue = sqlStringComma(&s);
ret->donor = sqlStringComma(&s);
ret->autolysisScore = sqlSignedComma(&s);
ret->ischemicTime = sqlStringComma(&s);
ret->rin = sqlFloatComma(&s);
ret->collectionSites = sqlStringComma(&s);
ret->batchId = sqlStringComma(&s);
ret->isolationType = sqlStringComma(&s);
ret->isolationDate = sqlStringComma(&s);
ret->pathNotes = sqlStringComma(&s);
*pS = s;
return ret;
}

void gtexSampleFree(struct gtexSample **pEl)
/* Free a single dynamically allocated gtexSample such as created
 * with gtexSampleLoad(). */
{
struct gtexSample *el;

if ((el = *pEl) == NULL) return;
freeMem(el->sampleId);
freeMem(el->tissue);
freeMem(el->donor);
freeMem(el->ischemicTime);
freeMem(el->collectionSites);
freeMem(el->batchId);
freeMem(el->isolationType);
freeMem(el->isolationDate);
freeMem(el->pathNotes);
freez(pEl);
}

void gtexSampleFreeList(struct gtexSample **pList)
/* Free a list of dynamically allocated gtexSample's */
{
struct gtexSample *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gtexSampleFree(&el);
    }
*pList = NULL;
}

void gtexSampleOutput(struct gtexSample *el, FILE *f, char sep, char lastSep) 
/* Print out gtexSample.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tissue);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->donor);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->autolysisScore);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ischemicTime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->rin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->collectionSites);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->batchId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->isolationType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->isolationDate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pathNotes);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void gtexSampleCreateTable(struct sqlConnection *conn, char *table)
/* Create GTEx sample table of given name. */
{
char query[1024];

sqlSafef(query, sizeof(query),
"CREATE TABLE %s (\n"
"    sampleId varchar(255) not null,   # GTEx sample identifier\n"
"    tissue varchar(255) not null,     # Tissue name\n"
"    donor varchar(255) not null,      # GTEx subject identifier\n"
"    autolysisScore int not null default '-1',	# Level of tissue self-digestion (0-3; none,mild,moderate,severe, -1 if unknown)\n"
"    ischemicTime varchar(255) not null default 'unknown',	# Time from tissue removal to preservation, in 4hr intervals\n"
"    rin float not null default '0.0',	# RNA Integrity Number\n"
"    collectionSites varchar(255) not null,	# GTEx Biospecimen Source Site list\n"
"    batchId varchar(255) not null,	# Nucleic acid isolation batch ID\n"
"    isolationType varchar(255) not null,	# Type of nucleic acid isolation\n"
"    isolationDate varchar(255) not null,	# Date of nucleic acid isolation\n"
"    pathNotes varchar(1024) not null default '',	# Pathology report notes\n"
"              #Indices\n"
"    PRIMARY KEY(sampleId)\n"
")\n",   table);
sqlRemakeTable(conn, table, query);
}
