/* gtexTissue.c was originally generated by the autoSql program, which also 
 * generated gtexTissue.h and gtexTissue.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gtexTissue.h"



char *gtexTissueCommaSepFieldNames = "id,name,description,organ,color,abbrev";

void gtexTissueStaticLoad(char **row, struct gtexTissue *ret)
/* Load a row from gtexTissue table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->description = row[2];
ret->organ = row[3];
ret->color = sqlUnsigned(row[4]);
ret->abbrev = row[5];
}

struct gtexTissue *gtexTissueLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all gtexTissue from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gtexTissueFreeList(). */
{
struct gtexTissue *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = gtexTissueLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void gtexTissueSaveToDb(struct sqlConnection *conn, struct gtexTissue *el, char *tableName, int updateSize)
/* Save gtexTissue as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s',%u,'%s')", 
	tableName,  el->id,  el->name,  el->description,  el->organ,  el->color,  el->abbrev);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct gtexTissue *gtexTissueLoad(char **row)
/* Load a gtexTissue from row fetched with select * from gtexTissue
 * from database.  Dispose of this with gtexTissueFree(). */
{
struct gtexTissue *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->description = cloneString(row[2]);
ret->organ = cloneString(row[3]);
ret->color = sqlUnsigned(row[4]);
ret->abbrev = cloneString(row[5]);
return ret;
}

struct gtexTissue *gtexTissueLoadAll(char *fileName) 
/* Load all gtexTissue from a whitespace-separated file.
 * Dispose of this with gtexTissueFreeList(). */
{
struct gtexTissue *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = gtexTissueLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexTissue *gtexTissueLoadAllByChar(char *fileName, char chopper) 
/* Load all gtexTissue from a chopper separated file.
 * Dispose of this with gtexTissueFreeList(). */
{
struct gtexTissue *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gtexTissueLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexTissue *gtexTissueCommaIn(char **pS, struct gtexTissue *ret)
/* Create a gtexTissue out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexTissue */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->organ = sqlStringComma(&s);
ret->color = sqlUnsignedComma(&s);
ret->abbrev = sqlStringComma(&s);
*pS = s;
return ret;
}

void gtexTissueFree(struct gtexTissue **pEl)
/* Free a single dynamically allocated gtexTissue such as created
 * with gtexTissueLoad(). */
{
struct gtexTissue *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
freeMem(el->organ);
freeMem(el->abbrev);
freez(pEl);
}

void gtexTissueFreeList(struct gtexTissue **pList)
/* Free a list of dynamically allocated gtexTissue's */
{
struct gtexTissue *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gtexTissueFree(&el);
    }
*pList = NULL;
}

void gtexTissueOutput(struct gtexTissue *el, FILE *f, char sep, char lastSep) 
/* Print out gtexTissue.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->organ);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->color);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->abbrev);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */
#include "hdb.h"
#include "gtexInfo.h"

void gtexTissueCreateTable(struct sqlConnection *conn, char *table)
/* Create expression record format table of given name. */
{
char query[1024];

sqlSafef(query, sizeof(query),
"CREATE TABLE %s (\n"
"    id int unsigned not null, # internal id\n"
"    name varchar(255) not null,       # short UCSC identifier\n"
"    description varchar(255) not null, # GTEx tissue type detail\n"
"    organ varchar(255) not null,      # GTEx tissue collection area\n"
"    color int unsigned not null,      # GTEx assigned color\n"
"    abbrev varchar(255) not null,     # GTEx abbreviation\n"
"              #Indices\n"
"    PRIMARY KEY(id)\n"
")\n",   table);
sqlRemakeTable(conn, table, query);
}

struct gtexTissue *gtexGetTissues(char *version)
/* Get tissue id, descriptions, colors, etc. */
{
char query[1024];
struct sqlConnection *conn = hAllocConn("hgFixed");
sqlSafef(query, sizeof(query), "select * from gtexTissue%s order by id", 
                gtexVersionSuffix(version));
struct gtexTissue *gtexTissues = gtexTissueLoadByQuery(conn, query);
hFreeConn(&conn);
return gtexTissues;
}

struct hash *gtexGetTissueSampleCount(char *version)
/* Return hash of sample counts keyed by tissue name */
{
char query[1024];
struct sqlResult *sr;
char **row;
struct sqlConnection *conn = hAllocConn("hgFixed");
sqlSafef(query, sizeof(query), "select tissue, count(tissue) from gtexSample%s group by tissue",
                                        gtexVersionSuffix(version));
struct hash *tscHash = hashNew(0);
sr = sqlGetResult(conn,query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    char *tissue = cloneString(row[0]);
    int samples = sqlUnsigned(row[1]);
    hashAddInt(tscHash, tissue, samples);
    }
sqlFreeResult(&sr);
hFreeConn(&conn);
return tscHash;
}

struct rgbColor gtexTissueBrightenColor(struct rgbColor rgb)
/* Increase brightness for better visibility of small items */
{
struct hslColor hsl = mgRgbToHsl(rgb);
hsl.s = min(1000, hsl.s + 300);
return mgHslToRgb(hsl);
}

char *gtexGetTissueDescription(int id, char *version)
/* Get description for a tissue specified by id.  
 * Use for single queries (o/w use gtexGetTissues) */
{
char query[1024];
struct sqlConnection *conn = hAllocConn("hgFixed");
sqlSafef(query, sizeof(query), "select description from gtexTissue%s where id=%d\n", 
                gtexVersionSuffix(version), id);
return sqlQuickString(conn, query);
}


