/* gtexTissueMedian.c was originally generated by the autoSql program, which also 
 * generated gtexTissueMedian.h and gtexTissueMedian.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gtexTissueMedian.h"



char *gtexTissueMedianCommaSepFieldNames = "geneId,tissueCount,scores";

struct gtexTissueMedian *gtexTissueMedianLoad(char **row)
/* Load a gtexTissueMedian from row fetched with select * from gtexTissueMedian
 * from database.  Dispose of this with gtexTissueMedianFree(). */
{
struct gtexTissueMedian *ret;

AllocVar(ret);
ret->tissueCount = sqlUnsigned(row[1]);
ret->geneId = cloneString(row[0]);
{
int sizeOne;
sqlFloatDynamicArray(row[2], &ret->scores, &sizeOne);
assert(sizeOne == ret->tissueCount);
}
return ret;
}

struct gtexTissueMedian *gtexTissueMedianLoadAll(char *fileName) 
/* Load all gtexTissueMedian from a whitespace-separated file.
 * Dispose of this with gtexTissueMedianFreeList(). */
{
struct gtexTissueMedian *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = gtexTissueMedianLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexTissueMedian *gtexTissueMedianLoadAllByChar(char *fileName, char chopper) 
/* Load all gtexTissueMedian from a chopper separated file.
 * Dispose of this with gtexTissueMedianFreeList(). */
{
struct gtexTissueMedian *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gtexTissueMedianLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gtexTissueMedian *gtexTissueMedianCommaIn(char **pS, struct gtexTissueMedian *ret)
/* Create a gtexTissueMedian out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexTissueMedian */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->geneId = sqlStringComma(&s);
ret->tissueCount = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->scores, ret->tissueCount);
for (i=0; i<ret->tissueCount; ++i)
    {
    ret->scores[i] = sqlFloatComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void gtexTissueMedianFree(struct gtexTissueMedian **pEl)
/* Free a single dynamically allocated gtexTissueMedian such as created
 * with gtexTissueMedianLoad(). */
{
struct gtexTissueMedian *el;

if ((el = *pEl) == NULL) return;
freeMem(el->geneId);
freeMem(el->scores);
freez(pEl);
}

void gtexTissueMedianFreeList(struct gtexTissueMedian **pList)
/* Free a list of dynamically allocated gtexTissueMedian's */
{
struct gtexTissueMedian *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gtexTissueMedianFree(&el);
    }
*pList = NULL;
}

void gtexTissueMedianOutput(struct gtexTissueMedian *el, FILE *f, char sep, char lastSep) 
/* Print out gtexTissueMedian.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->tissueCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->tissueCount; ++i)
    {
    fprintf(f, "%g", el->scores[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void gtexTissueMedianCreateTable(struct sqlConnection *conn, char *table)
/* Create expression record format table of given name. */
{
char query[1024];

sqlSafef(query, sizeof(query),
"CREATE TABLE %s (\n"
"    geneId varchar(255) not null,     # Gene identifier (ensembl)\n"
"    tissueCount int unsigned not null,# Number of tissues\n"
"    scores longblob not null,	       # Median expression levels for tissues (RPKM)\n"
"              #Indices\n"
"    PRIMARY KEY(geneId)\n"
")\n",   table);
sqlRemakeTable(conn, table, query);
}

