/* megablastInfo.c was originally generated by the autoSql program, which also 
 * generated megablastInfo.h and megablastInfo.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "megablastInfo.h"


void megablastInfoStaticLoad(char **row, struct megablastInfo *ret)
/* Load a row from megablastInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->evalue = sqlDouble(row[6]);
ret->percentident = sqlUnsigned(row[7]);
ret->fullname = row[8];
ret->taxid = sqlUnsigned(row[9]);
}

struct megablastInfo *megablastInfoLoad(char **row)
/* Load a megablastInfo from row fetched with select * from megablastInfo
 * from database.  Dispose of this with megablastInfoFree(). */
{
struct megablastInfo *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->evalue = sqlDouble(row[6]);
ret->percentident = sqlUnsigned(row[7]);
ret->fullname = cloneString(row[8]);
ret->taxid = sqlUnsigned(row[9]);
return ret;
}

struct megablastInfo *megablastInfoLoadAll(char *fileName) 
/* Load all megablastInfo from a whitespace-separated file.
 * Dispose of this with megablastInfoFreeList(). */
{
struct megablastInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = megablastInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct megablastInfo *megablastInfoLoadAllByChar(char *fileName, char chopper) 
/* Load all megablastInfo from a chopper separated file.
 * Dispose of this with megablastInfoFreeList(). */
{
struct megablastInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = megablastInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct megablastInfo *megablastInfoCommaIn(char **pS, struct megablastInfo *ret)
/* Create a megablastInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new megablastInfo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->evalue = sqlDoubleComma(&s);
ret->percentident = sqlUnsignedComma(&s);
ret->fullname = sqlStringComma(&s);
ret->taxid = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void megablastInfoFree(struct megablastInfo **pEl)
/* Free a single dynamically allocated megablastInfo such as created
 * with megablastInfoLoad(). */
{
struct megablastInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->fullname);
freez(pEl);
}

void megablastInfoFreeList(struct megablastInfo **pList)
/* Free a list of dynamically allocated megablastInfo's */
{
struct megablastInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    megablastInfoFree(&el);
    }
*pList = NULL;
}

void megablastInfoOutput(struct megablastInfo *el, FILE *f, char sep, char lastSep) 
/* Print out megablastInfo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->evalue);
fputc(sep,f);
fprintf(f, "%u", el->percentident);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fullname);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->taxid);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

