/* txEdgeBed.c was originally generated by the autoSql program, which also 
 * generated txEdgeBed.h and txEdgeBed.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "txEdgeBed.h"


/* definitions for type column */
static char *values_type[] = {"exon", "intron", NULL};
static struct hash *valhash_type = NULL;

void txEdgeBedStaticLoad(char **row, struct txEdgeBed *ret)
/* Load a row from txEdgeBed table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlSigned(row[1]);
ret->chromEnd = sqlSigned(row[2]);
ret->name = row[3];
ret->score = sqlSigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
safecpy(ret->startType, sizeof(ret->startType), row[6]);
ret->type = sqlEnumParse(row[7], values_type, &valhash_type);
safecpy(ret->endType, sizeof(ret->endType), row[8]);
}

struct txEdgeBed *txEdgeBedLoad(char **row)
/* Load a txEdgeBed from row fetched with select * from txEdgeBed
 * from database.  Dispose of this with txEdgeBedFree(). */
{
struct txEdgeBed *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlSigned(row[1]);
ret->chromEnd = sqlSigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlSigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
safecpy(ret->startType, sizeof(ret->startType), row[6]);
ret->type = sqlEnumParse(row[7], values_type, &valhash_type);
safecpy(ret->endType, sizeof(ret->endType), row[8]);
return ret;
}

struct txEdgeBed *txEdgeBedLoadAll(char *fileName) 
/* Load all txEdgeBed from a whitespace-separated file.
 * Dispose of this with txEdgeBedFreeList(). */
{
struct txEdgeBed *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = txEdgeBedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct txEdgeBed *txEdgeBedLoadAllByChar(char *fileName, char chopper) 
/* Load all txEdgeBed from a chopper separated file.
 * Dispose of this with txEdgeBedFreeList(). */
{
struct txEdgeBed *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = txEdgeBedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct txEdgeBed *txEdgeBedCommaIn(char **pS, struct txEdgeBed *ret)
/* Create a txEdgeBed out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txEdgeBed */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlSignedComma(&s);
ret->chromEnd = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
sqlFixedStringComma(&s, ret->startType, sizeof(ret->startType));
ret->type = sqlEnumComma(&s, values_type, &valhash_type);
sqlFixedStringComma(&s, ret->endType, sizeof(ret->endType));
*pS = s;
return ret;
}

void txEdgeBedFree(struct txEdgeBed **pEl)
/* Free a single dynamically allocated txEdgeBed such as created
 * with txEdgeBedLoad(). */
{
struct txEdgeBed *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void txEdgeBedFreeList(struct txEdgeBed **pList)
/* Free a list of dynamically allocated txEdgeBed's */
{
struct txEdgeBed *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    txEdgeBedFree(&el);
    }
*pList = NULL;
}

void txEdgeBedOutput(struct txEdgeBed *el, FILE *f, char sep, char lastSep) 
/* Print out txEdgeBed.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->chromStart);
fputc(sep,f);
fprintf(f, "%d", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->startType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->type, values_type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->endType);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

