table clinGenCnv
"Dosage Sensitivity scores from Clinical Genome Resource"
    (
    string chrom;      "Reference sequence chromosome or scaffold"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    string name;       "Short Name of item"
    uint   score;      "Score from 0-1000"
    char[1] strand;    "+ or -"
    uint thickStart;   "Start of where display should be thick (start codon)"
    uint thickEnd;     "End of where display should be thick (stop codon)"
    uint reserved;     "Used as itemRgb as of 2004-11-22"
    string url;       "ClinGen URL"
    string geneSymbol; "Gene Symbol or ISCA Region Name"
    string geneId;     "Gene ID or ISCA ID"
    string cytoBand;   "Cytoband"
    string dateLastEvaluated; "Last evaluation date"
    string _omimID; "OMIM Phenotype ID - Deprecated"
    string _omimDesc; "OMIM Phenotype Description - Deprecated"
    string triploScore; "Triploinsufficiency score"
    string triploDescription; "Triploinsufficiency phenotype description"
    string PMID1; "Associated PubMed ID 1"
    string PMID2; "Associated PubMed ID 2"
    string PMID3; "Associated PubMed ID 3"
    string PMID4; "Associated PubMed ID 4"
    string PMID5; "Associated PubMed ID 5"
    string PMID6; "Associated PubMed ID 6"
    lstring _mouseOver; "Mouseover string for the genome browser display"
    string mondoID; "Mondo disease ontology ID"
    )
