table nextstrainClade
"Clades assigned by nextstrain.org"
    (
    string chrom;      "Reference sequence accession"
    uint   chromStart; "Start position in reference"
    uint   chromEnd;   "End position in reference"
    string name;       "Name of clade"
    uint   score;      "Placeholder for BED compatibility (0)"
    char[1] strand;    "Placeholder for BED compatibility (+)"
    uint thickStart;   "Start of where display should be thick"
    uint thickEnd;     "End of where display should be thick"
    uint reserved;     "itemRgb color"
    int blockCount;    "Number of blocks (characteristic variants)"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"
    lstring variants;   "Mutations that occurred on the path from the reference to this clade"
    string dateInferred; "Date of clade branch inferred by TreeTime"
    string dateConfMin;  "Earliest date in TreeTime confidence interval"
    string dateConfMax;  "Latest date in TreeTime confidence interval"
    string countryInferred;  "Country inferred by TreeTime"
    string countryConf;      "Top-scoring countries and confidence from TreeTime"
    int sampleCount;   "Number of samples belonging to the clade"
    string[sampleCount] samples; "Samples belonging to the clade"
    )
