/* visiGene.c was originally generated by the autoSql program, which also 
 * generated visiGene.h and visiGene.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "visiGene.h"


void fileLocationStaticLoad(char **row, struct fileLocation *ret)
/* Load a row from fileLocation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct fileLocation *fileLocationLoad(char **row)
/* Load a fileLocation from row fetched with select * from fileLocation
 * from database.  Dispose of this with fileLocationFree(). */
{
struct fileLocation *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct fileLocation *fileLocationLoadAll(char *fileName) 
/* Load all fileLocation from a whitespace-separated file.
 * Dispose of this with fileLocationFreeList(). */
{
struct fileLocation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = fileLocationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct fileLocation *fileLocationLoadAllByChar(char *fileName, char chopper) 
/* Load all fileLocation from a chopper separated file.
 * Dispose of this with fileLocationFreeList(). */
{
struct fileLocation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = fileLocationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct fileLocation *fileLocationCommaIn(char **pS, struct fileLocation *ret)
/* Create a fileLocation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new fileLocation */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void fileLocationFree(struct fileLocation **pEl)
/* Free a single dynamically allocated fileLocation such as created
 * with fileLocationLoad(). */
{
struct fileLocation *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void fileLocationFreeList(struct fileLocation **pList)
/* Free a list of dynamically allocated fileLocation's */
{
struct fileLocation *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    fileLocationFree(&el);
    }
*pList = NULL;
}

void fileLocationOutput(struct fileLocation *el, FILE *f, char sep, char lastSep) 
/* Print out fileLocation.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void strainStaticLoad(char **row, struct strain *ret)
/* Load a row from strain table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->taxon = sqlSigned(row[1]);
ret->name = row[2];
}

struct strain *strainLoad(char **row)
/* Load a strain from row fetched with select * from strain
 * from database.  Dispose of this with strainFree(). */
{
struct strain *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->taxon = sqlSigned(row[1]);
ret->name = cloneString(row[2]);
return ret;
}

struct strain *strainLoadAll(char *fileName) 
/* Load all strain from a whitespace-separated file.
 * Dispose of this with strainFreeList(). */
{
struct strain *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = strainLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct strain *strainLoadAllByChar(char *fileName, char chopper) 
/* Load all strain from a chopper separated file.
 * Dispose of this with strainFreeList(). */
{
struct strain *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = strainLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct strain *strainCommaIn(char **pS, struct strain *ret)
/* Create a strain out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new strain */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->taxon = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void strainFree(struct strain **pEl)
/* Free a single dynamically allocated strain such as created
 * with strainLoad(). */
{
struct strain *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void strainFreeList(struct strain **pList)
/* Free a list of dynamically allocated strain's */
{
struct strain *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    strainFree(&el);
    }
*pList = NULL;
}

void strainOutput(struct strain *el, FILE *f, char sep, char lastSep) 
/* Print out strain.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->taxon);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void bodyPartStaticLoad(char **row, struct bodyPart *ret)
/* Load a row from bodyPart table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct bodyPart *bodyPartLoad(char **row)
/* Load a bodyPart from row fetched with select * from bodyPart
 * from database.  Dispose of this with bodyPartFree(). */
{
struct bodyPart *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct bodyPart *bodyPartLoadAll(char *fileName) 
/* Load all bodyPart from a whitespace-separated file.
 * Dispose of this with bodyPartFreeList(). */
{
struct bodyPart *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = bodyPartLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bodyPart *bodyPartLoadAllByChar(char *fileName, char chopper) 
/* Load all bodyPart from a chopper separated file.
 * Dispose of this with bodyPartFreeList(). */
{
struct bodyPart *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bodyPartLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bodyPart *bodyPartCommaIn(char **pS, struct bodyPart *ret)
/* Create a bodyPart out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bodyPart */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void bodyPartFree(struct bodyPart **pEl)
/* Free a single dynamically allocated bodyPart such as created
 * with bodyPartLoad(). */
{
struct bodyPart *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void bodyPartFreeList(struct bodyPart **pList)
/* Free a list of dynamically allocated bodyPart's */
{
struct bodyPart *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bodyPartFree(&el);
    }
*pList = NULL;
}

void bodyPartOutput(struct bodyPart *el, FILE *f, char sep, char lastSep) 
/* Print out bodyPart.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void cellTypeStaticLoad(char **row, struct cellType *ret)
/* Load a row from cellType table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct cellType *cellTypeLoad(char **row)
/* Load a cellType from row fetched with select * from cellType
 * from database.  Dispose of this with cellTypeFree(). */
{
struct cellType *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct cellType *cellTypeLoadAll(char *fileName) 
/* Load all cellType from a whitespace-separated file.
 * Dispose of this with cellTypeFreeList(). */
{
struct cellType *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = cellTypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cellType *cellTypeLoadAllByChar(char *fileName, char chopper) 
/* Load all cellType from a chopper separated file.
 * Dispose of this with cellTypeFreeList(). */
{
struct cellType *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cellTypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cellType *cellTypeCommaIn(char **pS, struct cellType *ret)
/* Create a cellType out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cellType */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void cellTypeFree(struct cellType **pEl)
/* Free a single dynamically allocated cellType such as created
 * with cellTypeLoad(). */
{
struct cellType *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void cellTypeFreeList(struct cellType **pList)
/* Free a list of dynamically allocated cellType's */
{
struct cellType *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cellTypeFree(&el);
    }
*pList = NULL;
}

void cellTypeOutput(struct cellType *el, FILE *f, char sep, char lastSep) 
/* Print out cellType.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void cellSubtypeStaticLoad(char **row, struct cellSubtype *ret)
/* Load a row from cellSubtype table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct cellSubtype *cellSubtypeLoad(char **row)
/* Load a cellSubtype from row fetched with select * from cellSubtype
 * from database.  Dispose of this with cellSubtypeFree(). */
{
struct cellSubtype *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct cellSubtype *cellSubtypeLoadAll(char *fileName) 
/* Load all cellSubtype from a whitespace-separated file.
 * Dispose of this with cellSubtypeFreeList(). */
{
struct cellSubtype *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = cellSubtypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cellSubtype *cellSubtypeLoadAllByChar(char *fileName, char chopper) 
/* Load all cellSubtype from a chopper separated file.
 * Dispose of this with cellSubtypeFreeList(). */
{
struct cellSubtype *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cellSubtypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cellSubtype *cellSubtypeCommaIn(char **pS, struct cellSubtype *ret)
/* Create a cellSubtype out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cellSubtype */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void cellSubtypeFree(struct cellSubtype **pEl)
/* Free a single dynamically allocated cellSubtype such as created
 * with cellSubtypeLoad(). */
{
struct cellSubtype *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void cellSubtypeFreeList(struct cellSubtype **pList)
/* Free a list of dynamically allocated cellSubtype's */
{
struct cellSubtype *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cellSubtypeFree(&el);
    }
*pList = NULL;
}

void cellSubtypeOutput(struct cellSubtype *el, FILE *f, char sep, char lastSep) 
/* Print out cellSubtype.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void sliceTypeStaticLoad(char **row, struct sliceType *ret)
/* Load a row from sliceType table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct sliceType *sliceTypeLoad(char **row)
/* Load a sliceType from row fetched with select * from sliceType
 * from database.  Dispose of this with sliceTypeFree(). */
{
struct sliceType *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct sliceType *sliceTypeLoadAll(char *fileName) 
/* Load all sliceType from a whitespace-separated file.
 * Dispose of this with sliceTypeFreeList(). */
{
struct sliceType *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = sliceTypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sliceType *sliceTypeLoadAllByChar(char *fileName, char chopper) 
/* Load all sliceType from a chopper separated file.
 * Dispose of this with sliceTypeFreeList(). */
{
struct sliceType *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = sliceTypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sliceType *sliceTypeCommaIn(char **pS, struct sliceType *ret)
/* Create a sliceType out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sliceType */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void sliceTypeFree(struct sliceType **pEl)
/* Free a single dynamically allocated sliceType such as created
 * with sliceTypeLoad(). */
{
struct sliceType *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void sliceTypeFreeList(struct sliceType **pList)
/* Free a list of dynamically allocated sliceType's */
{
struct sliceType *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    sliceTypeFree(&el);
    }
*pList = NULL;
}

void sliceTypeOutput(struct sliceType *el, FILE *f, char sep, char lastSep) 
/* Print out sliceType.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void fixationStaticLoad(char **row, struct fixation *ret)
/* Load a row from fixation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->description = row[1];
}

struct fixation *fixationLoad(char **row)
/* Load a fixation from row fetched with select * from fixation
 * from database.  Dispose of this with fixationFree(). */
{
struct fixation *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->description = cloneString(row[1]);
return ret;
}

struct fixation *fixationLoadAll(char *fileName) 
/* Load all fixation from a whitespace-separated file.
 * Dispose of this with fixationFreeList(). */
{
struct fixation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = fixationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct fixation *fixationLoadAllByChar(char *fileName, char chopper) 
/* Load all fixation from a chopper separated file.
 * Dispose of this with fixationFreeList(). */
{
struct fixation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = fixationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct fixation *fixationCommaIn(char **pS, struct fixation *ret)
/* Create a fixation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new fixation */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void fixationFree(struct fixation **pEl)
/* Free a single dynamically allocated fixation such as created
 * with fixationLoad(). */
{
struct fixation *el;

if ((el = *pEl) == NULL) return;
freeMem(el->description);
freez(pEl);
}

void fixationFreeList(struct fixation **pList)
/* Free a list of dynamically allocated fixation's */
{
struct fixation *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    fixationFree(&el);
    }
*pList = NULL;
}

void fixationOutput(struct fixation *el, FILE *f, char sep, char lastSep) 
/* Print out fixation.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void embeddingStaticLoad(char **row, struct embedding *ret)
/* Load a row from embedding table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->description = row[1];
}

struct embedding *embeddingLoad(char **row)
/* Load a embedding from row fetched with select * from embedding
 * from database.  Dispose of this with embeddingFree(). */
{
struct embedding *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->description = cloneString(row[1]);
return ret;
}

struct embedding *embeddingLoadAll(char *fileName) 
/* Load all embedding from a whitespace-separated file.
 * Dispose of this with embeddingFreeList(). */
{
struct embedding *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = embeddingLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct embedding *embeddingLoadAllByChar(char *fileName, char chopper) 
/* Load all embedding from a chopper separated file.
 * Dispose of this with embeddingFreeList(). */
{
struct embedding *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = embeddingLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct embedding *embeddingCommaIn(char **pS, struct embedding *ret)
/* Create a embedding out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new embedding */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void embeddingFree(struct embedding **pEl)
/* Free a single dynamically allocated embedding such as created
 * with embeddingLoad(). */
{
struct embedding *el;

if ((el = *pEl) == NULL) return;
freeMem(el->description);
freez(pEl);
}

void embeddingFreeList(struct embedding **pList)
/* Free a list of dynamically allocated embedding's */
{
struct embedding *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    embeddingFree(&el);
    }
*pList = NULL;
}

void embeddingOutput(struct embedding *el, FILE *f, char sep, char lastSep) 
/* Print out embedding.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void permeablizationStaticLoad(char **row, struct permeablization *ret)
/* Load a row from permeablization table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->description = row[1];
}

struct permeablization *permeablizationLoad(char **row)
/* Load a permeablization from row fetched with select * from permeablization
 * from database.  Dispose of this with permeablizationFree(). */
{
struct permeablization *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->description = cloneString(row[1]);
return ret;
}

struct permeablization *permeablizationLoadAll(char *fileName) 
/* Load all permeablization from a whitespace-separated file.
 * Dispose of this with permeablizationFreeList(). */
{
struct permeablization *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = permeablizationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct permeablization *permeablizationLoadAllByChar(char *fileName, char chopper) 
/* Load all permeablization from a chopper separated file.
 * Dispose of this with permeablizationFreeList(). */
{
struct permeablization *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = permeablizationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct permeablization *permeablizationCommaIn(char **pS, struct permeablization *ret)
/* Create a permeablization out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new permeablization */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void permeablizationFree(struct permeablization **pEl)
/* Free a single dynamically allocated permeablization such as created
 * with permeablizationLoad(). */
{
struct permeablization *el;

if ((el = *pEl) == NULL) return;
freeMem(el->description);
freez(pEl);
}

void permeablizationFreeList(struct permeablization **pList)
/* Free a list of dynamically allocated permeablization's */
{
struct permeablization *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    permeablizationFree(&el);
    }
*pList = NULL;
}

void permeablizationOutput(struct permeablization *el, FILE *f, char sep, char lastSep) 
/* Print out permeablization.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void contributorStaticLoad(char **row, struct contributor *ret)
/* Load a row from contributor table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct contributor *contributorLoad(char **row)
/* Load a contributor from row fetched with select * from contributor
 * from database.  Dispose of this with contributorFree(). */
{
struct contributor *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct contributor *contributorLoadAll(char *fileName) 
/* Load all contributor from a whitespace-separated file.
 * Dispose of this with contributorFreeList(). */
{
struct contributor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = contributorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct contributor *contributorLoadAllByChar(char *fileName, char chopper) 
/* Load all contributor from a chopper separated file.
 * Dispose of this with contributorFreeList(). */
{
struct contributor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = contributorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct contributor *contributorCommaIn(char **pS, struct contributor *ret)
/* Create a contributor out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new contributor */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void contributorFree(struct contributor **pEl)
/* Free a single dynamically allocated contributor such as created
 * with contributorLoad(). */
{
struct contributor *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void contributorFreeList(struct contributor **pList)
/* Free a list of dynamically allocated contributor's */
{
struct contributor *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    contributorFree(&el);
    }
*pList = NULL;
}

void contributorOutput(struct contributor *el, FILE *f, char sep, char lastSep) 
/* Print out contributor.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void journalStaticLoad(char **row, struct journal *ret)
/* Load a row from journal table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
ret->url = row[2];
}

struct journal *journalLoad(char **row)
/* Load a journal from row fetched with select * from journal
 * from database.  Dispose of this with journalFree(). */
{
struct journal *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
ret->url = cloneString(row[2]);
return ret;
}

struct journal *journalLoadAll(char *fileName) 
/* Load all journal from a whitespace-separated file.
 * Dispose of this with journalFreeList(). */
{
struct journal *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = journalLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct journal *journalLoadAllByChar(char *fileName, char chopper) 
/* Load all journal from a chopper separated file.
 * Dispose of this with journalFreeList(). */
{
struct journal *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = journalLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct journal *journalCommaIn(char **pS, struct journal *ret)
/* Create a journal out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new journal */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->url = sqlStringComma(&s);
*pS = s;
return ret;
}

void journalFree(struct journal **pEl)
/* Free a single dynamically allocated journal such as created
 * with journalLoad(). */
{
struct journal *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->url);
freez(pEl);
}

void journalFreeList(struct journal **pList)
/* Free a list of dynamically allocated journal's */
{
struct journal *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    journalFree(&el);
    }
*pList = NULL;
}

void journalOutput(struct journal *el, FILE *f, char sep, char lastSep) 
/* Print out journal.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void copyrightStaticLoad(char **row, struct copyright *ret)
/* Load a row from copyright table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->notice = row[1];
}

struct copyright *copyrightLoad(char **row)
/* Load a copyright from row fetched with select * from copyright
 * from database.  Dispose of this with copyrightFree(). */
{
struct copyright *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->notice = cloneString(row[1]);
return ret;
}

struct copyright *copyrightLoadAll(char *fileName) 
/* Load all copyright from a whitespace-separated file.
 * Dispose of this with copyrightFreeList(). */
{
struct copyright *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = copyrightLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct copyright *copyrightLoadAllByChar(char *fileName, char chopper) 
/* Load all copyright from a chopper separated file.
 * Dispose of this with copyrightFreeList(). */
{
struct copyright *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = copyrightLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct copyright *copyrightCommaIn(char **pS, struct copyright *ret)
/* Create a copyright out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new copyright */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->notice = sqlStringComma(&s);
*pS = s;
return ret;
}

void copyrightFree(struct copyright **pEl)
/* Free a single dynamically allocated copyright such as created
 * with copyrightLoad(). */
{
struct copyright *el;

if ((el = *pEl) == NULL) return;
freeMem(el->notice);
freez(pEl);
}

void copyrightFreeList(struct copyright **pList)
/* Free a list of dynamically allocated copyright's */
{
struct copyright *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    copyrightFree(&el);
    }
*pList = NULL;
}

void copyrightOutput(struct copyright *el, FILE *f, char sep, char lastSep) 
/* Print out copyright.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->notice);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void submissionSourceStaticLoad(char **row, struct submissionSource *ret)
/* Load a row from submissionSource table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
ret->acknowledgement = row[2];
ret->sourceUrl = row[3];
ret->itemUrl = row[4];
}

struct submissionSource *submissionSourceLoad(char **row)
/* Load a submissionSource from row fetched with select * from submissionSource
 * from database.  Dispose of this with submissionSourceFree(). */
{
struct submissionSource *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
ret->acknowledgement = cloneString(row[2]);
ret->sourceUrl = cloneString(row[3]);
ret->itemUrl = cloneString(row[4]);
return ret;
}

struct submissionSource *submissionSourceLoadAll(char *fileName) 
/* Load all submissionSource from a whitespace-separated file.
 * Dispose of this with submissionSourceFreeList(). */
{
struct submissionSource *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = submissionSourceLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct submissionSource *submissionSourceLoadAllByChar(char *fileName, char chopper) 
/* Load all submissionSource from a chopper separated file.
 * Dispose of this with submissionSourceFreeList(). */
{
struct submissionSource *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = submissionSourceLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct submissionSource *submissionSourceCommaIn(char **pS, struct submissionSource *ret)
/* Create a submissionSource out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new submissionSource */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->acknowledgement = sqlStringComma(&s);
ret->sourceUrl = sqlStringComma(&s);
ret->itemUrl = sqlStringComma(&s);
*pS = s;
return ret;
}

void submissionSourceFree(struct submissionSource **pEl)
/* Free a single dynamically allocated submissionSource such as created
 * with submissionSourceLoad(). */
{
struct submissionSource *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->acknowledgement);
freeMem(el->sourceUrl);
freeMem(el->itemUrl);
freez(pEl);
}

void submissionSourceFreeList(struct submissionSource **pList)
/* Free a list of dynamically allocated submissionSource's */
{
struct submissionSource *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    submissionSourceFree(&el);
    }
*pList = NULL;
}

void submissionSourceOutput(struct submissionSource *el, FILE *f, char sep, char lastSep) 
/* Print out submissionSource.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acknowledgement);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sourceUrl);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->itemUrl);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void submissionSetStaticLoad(char **row, struct submissionSet *ret)
/* Load a row from submissionSet table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
ret->contributors = row[2];
ret->year = sqlSigned(row[3]);
ret->publication = row[4];
ret->pubUrl = row[5];
ret->journal = sqlSigned(row[6]);
ret->copyright = sqlSigned(row[7]);
ret->submissionSource = sqlSigned(row[8]);
ret->privateUser = sqlSigned(row[9]);
}

struct submissionSet *submissionSetLoad(char **row)
/* Load a submissionSet from row fetched with select * from submissionSet
 * from database.  Dispose of this with submissionSetFree(). */
{
struct submissionSet *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
ret->contributors = cloneString(row[2]);
ret->year = sqlSigned(row[3]);
ret->publication = cloneString(row[4]);
ret->pubUrl = cloneString(row[5]);
ret->journal = sqlSigned(row[6]);
ret->copyright = sqlSigned(row[7]);
ret->submissionSource = sqlSigned(row[8]);
ret->privateUser = sqlSigned(row[9]);
return ret;
}

struct submissionSet *submissionSetLoadAll(char *fileName) 
/* Load all submissionSet from a whitespace-separated file.
 * Dispose of this with submissionSetFreeList(). */
{
struct submissionSet *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = submissionSetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct submissionSet *submissionSetLoadAllByChar(char *fileName, char chopper) 
/* Load all submissionSet from a chopper separated file.
 * Dispose of this with submissionSetFreeList(). */
{
struct submissionSet *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = submissionSetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct submissionSet *submissionSetCommaIn(char **pS, struct submissionSet *ret)
/* Create a submissionSet out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new submissionSet */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->contributors = sqlStringComma(&s);
ret->year = sqlSignedComma(&s);
ret->publication = sqlStringComma(&s);
ret->pubUrl = sqlStringComma(&s);
ret->journal = sqlSignedComma(&s);
ret->copyright = sqlSignedComma(&s);
ret->submissionSource = sqlSignedComma(&s);
ret->privateUser = sqlSignedComma(&s);
*pS = s;
return ret;
}

void submissionSetFree(struct submissionSet **pEl)
/* Free a single dynamically allocated submissionSet such as created
 * with submissionSetLoad(). */
{
struct submissionSet *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->contributors);
freeMem(el->publication);
freeMem(el->pubUrl);
freez(pEl);
}

void submissionSetFreeList(struct submissionSet **pList)
/* Free a list of dynamically allocated submissionSet's */
{
struct submissionSet *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    submissionSetFree(&el);
    }
*pList = NULL;
}

void submissionSetOutput(struct submissionSet *el, FILE *f, char sep, char lastSep) 
/* Print out submissionSet.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->contributors);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->year);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->publication);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pubUrl);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->journal);
fputc(sep,f);
fprintf(f, "%d", el->copyright);
fputc(sep,f);
fprintf(f, "%d", el->submissionSource);
fputc(sep,f);
fprintf(f, "%d", el->privateUser);
fputc(lastSep,f);
}

void submissionContributorStaticLoad(char **row, struct submissionContributor *ret)
/* Load a row from submissionContributor table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->submissionSet = sqlSigned(row[0]);
ret->contributor = sqlSigned(row[1]);
}

struct submissionContributor *submissionContributorLoad(char **row)
/* Load a submissionContributor from row fetched with select * from submissionContributor
 * from database.  Dispose of this with submissionContributorFree(). */
{
struct submissionContributor *ret;

AllocVar(ret);
ret->submissionSet = sqlSigned(row[0]);
ret->contributor = sqlSigned(row[1]);
return ret;
}

struct submissionContributor *submissionContributorLoadAll(char *fileName) 
/* Load all submissionContributor from a whitespace-separated file.
 * Dispose of this with submissionContributorFreeList(). */
{
struct submissionContributor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = submissionContributorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct submissionContributor *submissionContributorLoadAllByChar(char *fileName, char chopper) 
/* Load all submissionContributor from a chopper separated file.
 * Dispose of this with submissionContributorFreeList(). */
{
struct submissionContributor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = submissionContributorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct submissionContributor *submissionContributorCommaIn(char **pS, struct submissionContributor *ret)
/* Create a submissionContributor out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new submissionContributor */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->submissionSet = sqlSignedComma(&s);
ret->contributor = sqlSignedComma(&s);
*pS = s;
return ret;
}

void submissionContributorFree(struct submissionContributor **pEl)
/* Free a single dynamically allocated submissionContributor such as created
 * with submissionContributorLoad(). */
{
struct submissionContributor *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void submissionContributorFreeList(struct submissionContributor **pList)
/* Free a list of dynamically allocated submissionContributor's */
{
struct submissionContributor *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    submissionContributorFree(&el);
    }
*pList = NULL;
}

void submissionContributorOutput(struct submissionContributor *el, FILE *f, char sep, char lastSep) 
/* Print out submissionContributor.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->submissionSet);
fputc(sep,f);
fprintf(f, "%d", el->contributor);
fputc(lastSep,f);
}

void sectionSetStaticLoad(char **row, struct sectionSet *ret)
/* Load a row from sectionSet table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
}

struct sectionSet *sectionSetLoad(char **row)
/* Load a sectionSet from row fetched with select * from sectionSet
 * from database.  Dispose of this with sectionSetFree(). */
{
struct sectionSet *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
return ret;
}

struct sectionSet *sectionSetLoadAll(char *fileName) 
/* Load all sectionSet from a whitespace-separated file.
 * Dispose of this with sectionSetFreeList(). */
{
struct sectionSet *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[1];

while (lineFileRow(lf, row))
    {
    el = sectionSetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sectionSet *sectionSetLoadAllByChar(char *fileName, char chopper) 
/* Load all sectionSet from a chopper separated file.
 * Dispose of this with sectionSetFreeList(). */
{
struct sectionSet *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[1];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = sectionSetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sectionSet *sectionSetCommaIn(char **pS, struct sectionSet *ret)
/* Create a sectionSet out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sectionSet */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
*pS = s;
return ret;
}

void sectionSetFree(struct sectionSet **pEl)
/* Free a single dynamically allocated sectionSet such as created
 * with sectionSetLoad(). */
{
struct sectionSet *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void sectionSetFreeList(struct sectionSet **pList)
/* Free a list of dynamically allocated sectionSet's */
{
struct sectionSet *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    sectionSetFree(&el);
    }
*pList = NULL;
}

void sectionSetOutput(struct sectionSet *el, FILE *f, char sep, char lastSep) 
/* Print out sectionSet.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(lastSep,f);
}

void antibodyStaticLoad(char **row, struct antibody *ret)
/* Load a row from antibody table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
ret->description = row[2];
ret->taxon = sqlSigned(row[3]);
}

struct antibody *antibodyLoad(char **row)
/* Load a antibody from row fetched with select * from antibody
 * from database.  Dispose of this with antibodyFree(). */
{
struct antibody *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
ret->description = cloneString(row[2]);
ret->taxon = sqlSigned(row[3]);
return ret;
}

struct antibody *antibodyLoadAll(char *fileName) 
/* Load all antibody from a whitespace-separated file.
 * Dispose of this with antibodyFreeList(). */
{
struct antibody *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = antibodyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct antibody *antibodyLoadAllByChar(char *fileName, char chopper) 
/* Load all antibody from a chopper separated file.
 * Dispose of this with antibodyFreeList(). */
{
struct antibody *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = antibodyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct antibody *antibodyCommaIn(char **pS, struct antibody *ret)
/* Create a antibody out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new antibody */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->taxon = sqlSignedComma(&s);
*pS = s;
return ret;
}

void antibodyFree(struct antibody **pEl)
/* Free a single dynamically allocated antibody such as created
 * with antibodyLoad(). */
{
struct antibody *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
freez(pEl);
}

void antibodyFreeList(struct antibody **pList)
/* Free a list of dynamically allocated antibody's */
{
struct antibody *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    antibodyFree(&el);
    }
*pList = NULL;
}

void antibodyOutput(struct antibody *el, FILE *f, char sep, char lastSep) 
/* Print out antibody.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->taxon);
fputc(lastSep,f);
}

void bacStaticLoad(char **row, struct bac *ret)
/* Load a row from bac table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct bac *bacLoad(char **row)
/* Load a bac from row fetched with select * from bac
 * from database.  Dispose of this with bacFree(). */
{
struct bac *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct bac *bacLoadAll(char *fileName) 
/* Load all bac from a whitespace-separated file.
 * Dispose of this with bacFreeList(). */
{
struct bac *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = bacLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bac *bacLoadAllByChar(char *fileName, char chopper) 
/* Load all bac from a chopper separated file.
 * Dispose of this with bacFreeList(). */
{
struct bac *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bacLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bac *bacCommaIn(char **pS, struct bac *ret)
/* Create a bac out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bac */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void bacFree(struct bac **pEl)
/* Free a single dynamically allocated bac such as created
 * with bacLoad(). */
{
struct bac *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void bacFreeList(struct bac **pList)
/* Free a list of dynamically allocated bac's */
{
struct bac *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bacFree(&el);
    }
*pList = NULL;
}

void bacOutput(struct bac *el, FILE *f, char sep, char lastSep) 
/* Print out bac.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void geneStaticLoad(char **row, struct gene *ret)
/* Load a row from gene table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
ret->locusLink = row[2];
ret->refSeq = row[3];
ret->genbank = row[4];
ret->uniProt = row[5];
ret->taxon = sqlSigned(row[6]);
}

struct gene *geneLoad(char **row)
/* Load a gene from row fetched with select * from gene
 * from database.  Dispose of this with geneFree(). */
{
struct gene *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
ret->locusLink = cloneString(row[2]);
ret->refSeq = cloneString(row[3]);
ret->genbank = cloneString(row[4]);
ret->uniProt = cloneString(row[5]);
ret->taxon = sqlSigned(row[6]);
return ret;
}

struct gene *geneLoadAll(char *fileName) 
/* Load all gene from a whitespace-separated file.
 * Dispose of this with geneFreeList(). */
{
struct gene *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = geneLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gene *geneLoadAllByChar(char *fileName, char chopper) 
/* Load all gene from a chopper separated file.
 * Dispose of this with geneFreeList(). */
{
struct gene *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = geneLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gene *geneCommaIn(char **pS, struct gene *ret)
/* Create a gene out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gene */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->locusLink = sqlStringComma(&s);
ret->refSeq = sqlStringComma(&s);
ret->genbank = sqlStringComma(&s);
ret->uniProt = sqlStringComma(&s);
ret->taxon = sqlSignedComma(&s);
*pS = s;
return ret;
}

void geneFree(struct gene **pEl)
/* Free a single dynamically allocated gene such as created
 * with geneLoad(). */
{
struct gene *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->locusLink);
freeMem(el->refSeq);
freeMem(el->genbank);
freeMem(el->uniProt);
freez(pEl);
}

void geneFreeList(struct gene **pList)
/* Free a list of dynamically allocated gene's */
{
struct gene *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    geneFree(&el);
    }
*pList = NULL;
}

void geneOutput(struct gene *el, FILE *f, char sep, char lastSep) 
/* Print out gene.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->locusLink);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refSeq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->genbank);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->uniProt);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->taxon);
fputc(lastSep,f);
}

void geneSynonymStaticLoad(char **row, struct geneSynonym *ret)
/* Load a row from geneSynonym table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->gene = sqlSigned(row[0]);
ret->name = row[1];
}

struct geneSynonym *geneSynonymLoad(char **row)
/* Load a geneSynonym from row fetched with select * from geneSynonym
 * from database.  Dispose of this with geneSynonymFree(). */
{
struct geneSynonym *ret;

AllocVar(ret);
ret->gene = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct geneSynonym *geneSynonymLoadAll(char *fileName) 
/* Load all geneSynonym from a whitespace-separated file.
 * Dispose of this with geneSynonymFreeList(). */
{
struct geneSynonym *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = geneSynonymLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneSynonym *geneSynonymLoadAllByChar(char *fileName, char chopper) 
/* Load all geneSynonym from a chopper separated file.
 * Dispose of this with geneSynonymFreeList(). */
{
struct geneSynonym *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = geneSynonymLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneSynonym *geneSynonymCommaIn(char **pS, struct geneSynonym *ret)
/* Create a geneSynonym out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneSynonym */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->gene = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void geneSynonymFree(struct geneSynonym **pEl)
/* Free a single dynamically allocated geneSynonym such as created
 * with geneSynonymLoad(). */
{
struct geneSynonym *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void geneSynonymFreeList(struct geneSynonym **pList)
/* Free a list of dynamically allocated geneSynonym's */
{
struct geneSynonym *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    geneSynonymFree(&el);
    }
*pList = NULL;
}

void geneSynonymOutput(struct geneSynonym *el, FILE *f, char sep, char lastSep) 
/* Print out geneSynonym.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->gene);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void alleleStaticLoad(char **row, struct allele *ret)
/* Load a row from allele table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->gene = sqlSigned(row[1]);
ret->name = row[2];
}

struct allele *alleleLoad(char **row)
/* Load a allele from row fetched with select * from allele
 * from database.  Dispose of this with alleleFree(). */
{
struct allele *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->gene = sqlSigned(row[1]);
ret->name = cloneString(row[2]);
return ret;
}

struct allele *alleleLoadAll(char *fileName) 
/* Load all allele from a whitespace-separated file.
 * Dispose of this with alleleFreeList(). */
{
struct allele *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = alleleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct allele *alleleLoadAllByChar(char *fileName, char chopper) 
/* Load all allele from a chopper separated file.
 * Dispose of this with alleleFreeList(). */
{
struct allele *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = alleleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct allele *alleleCommaIn(char **pS, struct allele *ret)
/* Create a allele out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new allele */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->gene = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void alleleFree(struct allele **pEl)
/* Free a single dynamically allocated allele such as created
 * with alleleLoad(). */
{
struct allele *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void alleleFreeList(struct allele **pList)
/* Free a list of dynamically allocated allele's */
{
struct allele *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    alleleFree(&el);
    }
*pList = NULL;
}

void alleleOutput(struct allele *el, FILE *f, char sep, char lastSep) 
/* Print out allele.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->gene);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void genotypeStaticLoad(char **row, struct genotype *ret)
/* Load a row from genotype table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->taxon = sqlSigned(row[1]);
ret->strain = sqlSigned(row[2]);
ret->alleles = row[3];
}

struct genotype *genotypeLoad(char **row)
/* Load a genotype from row fetched with select * from genotype
 * from database.  Dispose of this with genotypeFree(). */
{
struct genotype *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->taxon = sqlSigned(row[1]);
ret->strain = sqlSigned(row[2]);
ret->alleles = cloneString(row[3]);
return ret;
}

struct genotype *genotypeLoadAll(char *fileName) 
/* Load all genotype from a whitespace-separated file.
 * Dispose of this with genotypeFreeList(). */
{
struct genotype *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = genotypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct genotype *genotypeLoadAllByChar(char *fileName, char chopper) 
/* Load all genotype from a chopper separated file.
 * Dispose of this with genotypeFreeList(). */
{
struct genotype *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = genotypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct genotype *genotypeCommaIn(char **pS, struct genotype *ret)
/* Create a genotype out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new genotype */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->taxon = sqlSignedComma(&s);
ret->strain = sqlSignedComma(&s);
ret->alleles = sqlStringComma(&s);
*pS = s;
return ret;
}

void genotypeFree(struct genotype **pEl)
/* Free a single dynamically allocated genotype such as created
 * with genotypeLoad(). */
{
struct genotype *el;

if ((el = *pEl) == NULL) return;
freeMem(el->alleles);
freez(pEl);
}

void genotypeFreeList(struct genotype **pList)
/* Free a list of dynamically allocated genotype's */
{
struct genotype *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    genotypeFree(&el);
    }
*pList = NULL;
}

void genotypeOutput(struct genotype *el, FILE *f, char sep, char lastSep) 
/* Print out genotype.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->taxon);
fputc(sep,f);
fprintf(f, "%d", el->strain);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->alleles);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void genotypeAlleleStaticLoad(char **row, struct genotypeAllele *ret)
/* Load a row from genotypeAllele table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->genotype = sqlSigned(row[0]);
ret->allele = sqlSigned(row[1]);
}

struct genotypeAllele *genotypeAlleleLoad(char **row)
/* Load a genotypeAllele from row fetched with select * from genotypeAllele
 * from database.  Dispose of this with genotypeAlleleFree(). */
{
struct genotypeAllele *ret;

AllocVar(ret);
ret->genotype = sqlSigned(row[0]);
ret->allele = sqlSigned(row[1]);
return ret;
}

struct genotypeAllele *genotypeAlleleLoadAll(char *fileName) 
/* Load all genotypeAllele from a whitespace-separated file.
 * Dispose of this with genotypeAlleleFreeList(). */
{
struct genotypeAllele *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = genotypeAlleleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct genotypeAllele *genotypeAlleleLoadAllByChar(char *fileName, char chopper) 
/* Load all genotypeAllele from a chopper separated file.
 * Dispose of this with genotypeAlleleFreeList(). */
{
struct genotypeAllele *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = genotypeAlleleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct genotypeAllele *genotypeAlleleCommaIn(char **pS, struct genotypeAllele *ret)
/* Create a genotypeAllele out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new genotypeAllele */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->genotype = sqlSignedComma(&s);
ret->allele = sqlSignedComma(&s);
*pS = s;
return ret;
}

void genotypeAlleleFree(struct genotypeAllele **pEl)
/* Free a single dynamically allocated genotypeAllele such as created
 * with genotypeAlleleLoad(). */
{
struct genotypeAllele *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void genotypeAlleleFreeList(struct genotypeAllele **pList)
/* Free a list of dynamically allocated genotypeAllele's */
{
struct genotypeAllele *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    genotypeAlleleFree(&el);
    }
*pList = NULL;
}

void genotypeAlleleOutput(struct genotypeAllele *el, FILE *f, char sep, char lastSep) 
/* Print out genotypeAllele.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->genotype);
fputc(sep,f);
fprintf(f, "%d", el->allele);
fputc(lastSep,f);
}

void sexStaticLoad(char **row, struct sex *ret)
/* Load a row from sex table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct sex *sexLoad(char **row)
/* Load a sex from row fetched with select * from sex
 * from database.  Dispose of this with sexFree(). */
{
struct sex *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct sex *sexLoadAll(char *fileName) 
/* Load all sex from a whitespace-separated file.
 * Dispose of this with sexFreeList(). */
{
struct sex *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = sexLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sex *sexLoadAllByChar(char *fileName, char chopper) 
/* Load all sex from a chopper separated file.
 * Dispose of this with sexFreeList(). */
{
struct sex *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = sexLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sex *sexCommaIn(char **pS, struct sex *ret)
/* Create a sex out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sex */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void sexFree(struct sex **pEl)
/* Free a single dynamically allocated sex such as created
 * with sexLoad(). */
{
struct sex *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void sexFreeList(struct sex **pList)
/* Free a list of dynamically allocated sex's */
{
struct sex *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    sexFree(&el);
    }
*pList = NULL;
}

void sexOutput(struct sex *el, FILE *f, char sep, char lastSep) 
/* Print out sex.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void specimenStaticLoad(char **row, struct specimen *ret)
/* Load a row from specimen table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
ret->taxon = sqlSigned(row[2]);
ret->genotype = sqlSigned(row[3]);
ret->bodyPart = sqlSigned(row[4]);
ret->sex = sqlSigned(row[5]);
ret->age = atof(row[6]);
ret->minAge = atof(row[7]);
ret->maxAge = atof(row[8]);
ret->notes = row[9];
}

struct specimen *specimenLoad(char **row)
/* Load a specimen from row fetched with select * from specimen
 * from database.  Dispose of this with specimenFree(). */
{
struct specimen *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
ret->taxon = sqlSigned(row[2]);
ret->genotype = sqlSigned(row[3]);
ret->bodyPart = sqlSigned(row[4]);
ret->sex = sqlSigned(row[5]);
ret->age = atof(row[6]);
ret->minAge = atof(row[7]);
ret->maxAge = atof(row[8]);
ret->notes = cloneString(row[9]);
return ret;
}

struct specimen *specimenLoadAll(char *fileName) 
/* Load all specimen from a whitespace-separated file.
 * Dispose of this with specimenFreeList(). */
{
struct specimen *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = specimenLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct specimen *specimenLoadAllByChar(char *fileName, char chopper) 
/* Load all specimen from a chopper separated file.
 * Dispose of this with specimenFreeList(). */
{
struct specimen *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = specimenLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct specimen *specimenCommaIn(char **pS, struct specimen *ret)
/* Create a specimen out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new specimen */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->taxon = sqlSignedComma(&s);
ret->genotype = sqlSignedComma(&s);
ret->bodyPart = sqlSignedComma(&s);
ret->sex = sqlSignedComma(&s);
ret->age = sqlFloatComma(&s);
ret->minAge = sqlFloatComma(&s);
ret->maxAge = sqlFloatComma(&s);
ret->notes = sqlStringComma(&s);
*pS = s;
return ret;
}

void specimenFree(struct specimen **pEl)
/* Free a single dynamically allocated specimen such as created
 * with specimenLoad(). */
{
struct specimen *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->notes);
freez(pEl);
}

void specimenFreeList(struct specimen **pList)
/* Free a list of dynamically allocated specimen's */
{
struct specimen *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    specimenFree(&el);
    }
*pList = NULL;
}

void specimenOutput(struct specimen *el, FILE *f, char sep, char lastSep) 
/* Print out specimen.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->taxon);
fputc(sep,f);
fprintf(f, "%d", el->genotype);
fputc(sep,f);
fprintf(f, "%d", el->bodyPart);
fputc(sep,f);
fprintf(f, "%d", el->sex);
fputc(sep,f);
fprintf(f, "%g", el->age);
fputc(sep,f);
fprintf(f, "%g", el->minAge);
fputc(sep,f);
fprintf(f, "%g", el->maxAge);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->notes);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void preparationStaticLoad(char **row, struct preparation *ret)
/* Load a row from preparation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->fixation = sqlSigned(row[1]);
ret->embedding = sqlSigned(row[2]);
ret->permeablization = sqlSigned(row[3]);
ret->sliceType = sqlSigned(row[4]);
ret->notes = row[5];
}

struct preparation *preparationLoad(char **row)
/* Load a preparation from row fetched with select * from preparation
 * from database.  Dispose of this with preparationFree(). */
{
struct preparation *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->fixation = sqlSigned(row[1]);
ret->embedding = sqlSigned(row[2]);
ret->permeablization = sqlSigned(row[3]);
ret->sliceType = sqlSigned(row[4]);
ret->notes = cloneString(row[5]);
return ret;
}

struct preparation *preparationLoadAll(char *fileName) 
/* Load all preparation from a whitespace-separated file.
 * Dispose of this with preparationFreeList(). */
{
struct preparation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = preparationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct preparation *preparationLoadAllByChar(char *fileName, char chopper) 
/* Load all preparation from a chopper separated file.
 * Dispose of this with preparationFreeList(). */
{
struct preparation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = preparationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct preparation *preparationCommaIn(char **pS, struct preparation *ret)
/* Create a preparation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new preparation */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->fixation = sqlSignedComma(&s);
ret->embedding = sqlSignedComma(&s);
ret->permeablization = sqlSignedComma(&s);
ret->sliceType = sqlSignedComma(&s);
ret->notes = sqlStringComma(&s);
*pS = s;
return ret;
}

void preparationFree(struct preparation **pEl)
/* Free a single dynamically allocated preparation such as created
 * with preparationLoad(). */
{
struct preparation *el;

if ((el = *pEl) == NULL) return;
freeMem(el->notes);
freez(pEl);
}

void preparationFreeList(struct preparation **pList)
/* Free a list of dynamically allocated preparation's */
{
struct preparation *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    preparationFree(&el);
    }
*pList = NULL;
}

void preparationOutput(struct preparation *el, FILE *f, char sep, char lastSep) 
/* Print out preparation.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->fixation);
fputc(sep,f);
fprintf(f, "%d", el->embedding);
fputc(sep,f);
fprintf(f, "%d", el->permeablization);
fputc(sep,f);
fprintf(f, "%d", el->sliceType);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->notes);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void probeTypeStaticLoad(char **row, struct probeType *ret)
/* Load a row from probeType table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct probeType *probeTypeLoad(char **row)
/* Load a probeType from row fetched with select * from probeType
 * from database.  Dispose of this with probeTypeFree(). */
{
struct probeType *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct probeType *probeTypeLoadAll(char *fileName) 
/* Load all probeType from a whitespace-separated file.
 * Dispose of this with probeTypeFreeList(). */
{
struct probeType *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = probeTypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct probeType *probeTypeLoadAllByChar(char *fileName, char chopper) 
/* Load all probeType from a chopper separated file.
 * Dispose of this with probeTypeFreeList(). */
{
struct probeType *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = probeTypeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct probeType *probeTypeCommaIn(char **pS, struct probeType *ret)
/* Create a probeType out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new probeType */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void probeTypeFree(struct probeType **pEl)
/* Free a single dynamically allocated probeType such as created
 * with probeTypeLoad(). */
{
struct probeType *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void probeTypeFreeList(struct probeType **pList)
/* Free a list of dynamically allocated probeType's */
{
struct probeType *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    probeTypeFree(&el);
    }
*pList = NULL;
}

void probeTypeOutput(struct probeType *el, FILE *f, char sep, char lastSep) 
/* Print out probeType.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void probeStaticLoad(char **row, struct probe *ret)
/* Load a row from probe table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->gene = sqlSigned(row[1]);
ret->antibody = sqlSigned(row[2]);
ret->probeType = sqlSigned(row[3]);
ret->fPrimer = row[4];
ret->rPrimer = row[5];
ret->seq = row[6];
ret->bac = sqlSigned(row[7]);
}

struct probe *probeLoad(char **row)
/* Load a probe from row fetched with select * from probe
 * from database.  Dispose of this with probeFree(). */
{
struct probe *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->gene = sqlSigned(row[1]);
ret->antibody = sqlSigned(row[2]);
ret->probeType = sqlSigned(row[3]);
ret->fPrimer = cloneString(row[4]);
ret->rPrimer = cloneString(row[5]);
ret->seq = cloneString(row[6]);
ret->bac = sqlSigned(row[7]);
return ret;
}

struct probe *probeLoadAll(char *fileName) 
/* Load all probe from a whitespace-separated file.
 * Dispose of this with probeFreeList(). */
{
struct probe *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = probeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct probe *probeLoadAllByChar(char *fileName, char chopper) 
/* Load all probe from a chopper separated file.
 * Dispose of this with probeFreeList(). */
{
struct probe *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = probeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct probe *probeCommaIn(char **pS, struct probe *ret)
/* Create a probe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new probe */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->gene = sqlSignedComma(&s);
ret->antibody = sqlSignedComma(&s);
ret->probeType = sqlSignedComma(&s);
ret->fPrimer = sqlStringComma(&s);
ret->rPrimer = sqlStringComma(&s);
ret->seq = sqlStringComma(&s);
ret->bac = sqlSignedComma(&s);
*pS = s;
return ret;
}

void probeFree(struct probe **pEl)
/* Free a single dynamically allocated probe such as created
 * with probeLoad(). */
{
struct probe *el;

if ((el = *pEl) == NULL) return;
freeMem(el->fPrimer);
freeMem(el->rPrimer);
freeMem(el->seq);
freez(pEl);
}

void probeFreeList(struct probe **pList)
/* Free a list of dynamically allocated probe's */
{
struct probe *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    probeFree(&el);
    }
*pList = NULL;
}

void probeOutput(struct probe *el, FILE *f, char sep, char lastSep) 
/* Print out probe.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->gene);
fputc(sep,f);
fprintf(f, "%d", el->antibody);
fputc(sep,f);
fprintf(f, "%d", el->probeType);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fPrimer);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rPrimer);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->seq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->bac);
fputc(lastSep,f);
}

void probeColorStaticLoad(char **row, struct probeColor *ret)
/* Load a row from probeColor table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->name = row[1];
}

struct probeColor *probeColorLoad(char **row)
/* Load a probeColor from row fetched with select * from probeColor
 * from database.  Dispose of this with probeColorFree(). */
{
struct probeColor *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
return ret;
}

struct probeColor *probeColorLoadAll(char *fileName) 
/* Load all probeColor from a whitespace-separated file.
 * Dispose of this with probeColorFreeList(). */
{
struct probeColor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = probeColorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct probeColor *probeColorLoadAllByChar(char *fileName, char chopper) 
/* Load all probeColor from a chopper separated file.
 * Dispose of this with probeColorFreeList(). */
{
struct probeColor *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = probeColorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct probeColor *probeColorCommaIn(char **pS, struct probeColor *ret)
/* Create a probeColor out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new probeColor */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void probeColorFree(struct probeColor **pEl)
/* Free a single dynamically allocated probeColor such as created
 * with probeColorLoad(). */
{
struct probeColor *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void probeColorFreeList(struct probeColor **pList)
/* Free a list of dynamically allocated probeColor's */
{
struct probeColor *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    probeColorFree(&el);
    }
*pList = NULL;
}

void probeColorOutput(struct probeColor *el, FILE *f, char sep, char lastSep) 
/* Print out probeColor.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void captionStaticLoad(char **row, struct caption *ret)
/* Load a row from caption table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->caption = row[1];
}

struct caption *captionLoad(char **row)
/* Load a caption from row fetched with select * from caption
 * from database.  Dispose of this with captionFree(). */
{
struct caption *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->caption = cloneString(row[1]);
return ret;
}

struct caption *captionLoadAll(char *fileName) 
/* Load all caption from a whitespace-separated file.
 * Dispose of this with captionFreeList(). */
{
struct caption *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = captionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct caption *captionLoadAllByChar(char *fileName, char chopper) 
/* Load all caption from a chopper separated file.
 * Dispose of this with captionFreeList(). */
{
struct caption *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = captionLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct caption *captionCommaIn(char **pS, struct caption *ret)
/* Create a caption out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new caption */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->caption = sqlStringComma(&s);
*pS = s;
return ret;
}

void captionFree(struct caption **pEl)
/* Free a single dynamically allocated caption such as created
 * with captionLoad(). */
{
struct caption *el;

if ((el = *pEl) == NULL) return;
freeMem(el->caption);
freez(pEl);
}

void captionFreeList(struct caption **pList)
/* Free a list of dynamically allocated caption's */
{
struct caption *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    captionFree(&el);
    }
*pList = NULL;
}

void captionOutput(struct caption *el, FILE *f, char sep, char lastSep) 
/* Print out caption.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->caption);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void imageFileStaticLoad(char **row, struct imageFile *ret)
/* Load a row from imageFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->fileName = row[1];
ret->priority = atof(row[2]);
ret->imageWidth = sqlSigned(row[3]);
ret->imageHeight = sqlSigned(row[4]);
ret->fullLocation = sqlSigned(row[5]);
ret->thumbLocation = sqlSigned(row[6]);
ret->submissionSet = sqlSigned(row[7]);
ret->submitId = row[8];
ret->caption = sqlSigned(row[9]);
}

struct imageFile *imageFileLoad(char **row)
/* Load a imageFile from row fetched with select * from imageFile
 * from database.  Dispose of this with imageFileFree(). */
{
struct imageFile *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->fileName = cloneString(row[1]);
ret->priority = atof(row[2]);
ret->imageWidth = sqlSigned(row[3]);
ret->imageHeight = sqlSigned(row[4]);
ret->fullLocation = sqlSigned(row[5]);
ret->thumbLocation = sqlSigned(row[6]);
ret->submissionSet = sqlSigned(row[7]);
ret->submitId = cloneString(row[8]);
ret->caption = sqlSigned(row[9]);
return ret;
}

struct imageFile *imageFileLoadAll(char *fileName) 
/* Load all imageFile from a whitespace-separated file.
 * Dispose of this with imageFileFreeList(). */
{
struct imageFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = imageFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct imageFile *imageFileLoadAllByChar(char *fileName, char chopper) 
/* Load all imageFile from a chopper separated file.
 * Dispose of this with imageFileFreeList(). */
{
struct imageFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = imageFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct imageFile *imageFileCommaIn(char **pS, struct imageFile *ret)
/* Create a imageFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new imageFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->fileName = sqlStringComma(&s);
ret->priority = sqlFloatComma(&s);
ret->imageWidth = sqlSignedComma(&s);
ret->imageHeight = sqlSignedComma(&s);
ret->fullLocation = sqlSignedComma(&s);
ret->thumbLocation = sqlSignedComma(&s);
ret->submissionSet = sqlSignedComma(&s);
ret->submitId = sqlStringComma(&s);
ret->caption = sqlSignedComma(&s);
*pS = s;
return ret;
}

void imageFileFree(struct imageFile **pEl)
/* Free a single dynamically allocated imageFile such as created
 * with imageFileLoad(). */
{
struct imageFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->fileName);
freeMem(el->submitId);
freez(pEl);
}

void imageFileFreeList(struct imageFile **pList)
/* Free a list of dynamically allocated imageFile's */
{
struct imageFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    imageFileFree(&el);
    }
*pList = NULL;
}

void imageFileOutput(struct imageFile *el, FILE *f, char sep, char lastSep) 
/* Print out imageFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->priority);
fputc(sep,f);
fprintf(f, "%d", el->imageWidth);
fputc(sep,f);
fprintf(f, "%d", el->imageHeight);
fputc(sep,f);
fprintf(f, "%d", el->fullLocation);
fputc(sep,f);
fprintf(f, "%d", el->thumbLocation);
fputc(sep,f);
fprintf(f, "%d", el->submissionSet);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->submitId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->caption);
fputc(lastSep,f);
}

void imageStaticLoad(char **row, struct image *ret)
/* Load a row from image table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->submissionSet = sqlSigned(row[1]);
ret->imageFile = sqlSigned(row[2]);
ret->imagePos = sqlSigned(row[3]);
ret->paneLabel = row[4];
ret->sectionSet = sqlSigned(row[5]);
ret->sectionIx = sqlSigned(row[6]);
ret->specimen = sqlSigned(row[7]);
ret->preparation = sqlSigned(row[8]);
}

struct image *imageLoad(char **row)
/* Load a image from row fetched with select * from image
 * from database.  Dispose of this with imageFree(). */
{
struct image *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->submissionSet = sqlSigned(row[1]);
ret->imageFile = sqlSigned(row[2]);
ret->imagePos = sqlSigned(row[3]);
ret->paneLabel = cloneString(row[4]);
ret->sectionSet = sqlSigned(row[5]);
ret->sectionIx = sqlSigned(row[6]);
ret->specimen = sqlSigned(row[7]);
ret->preparation = sqlSigned(row[8]);
return ret;
}

struct image *imageLoadAll(char *fileName) 
/* Load all image from a whitespace-separated file.
 * Dispose of this with imageFreeList(). */
{
struct image *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = imageLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct image *imageLoadAllByChar(char *fileName, char chopper) 
/* Load all image from a chopper separated file.
 * Dispose of this with imageFreeList(). */
{
struct image *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = imageLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct image *imageCommaIn(char **pS, struct image *ret)
/* Create a image out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new image */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->submissionSet = sqlSignedComma(&s);
ret->imageFile = sqlSignedComma(&s);
ret->imagePos = sqlSignedComma(&s);
ret->paneLabel = sqlStringComma(&s);
ret->sectionSet = sqlSignedComma(&s);
ret->sectionIx = sqlSignedComma(&s);
ret->specimen = sqlSignedComma(&s);
ret->preparation = sqlSignedComma(&s);
*pS = s;
return ret;
}

void imageFree(struct image **pEl)
/* Free a single dynamically allocated image such as created
 * with imageLoad(). */
{
struct image *el;

if ((el = *pEl) == NULL) return;
freeMem(el->paneLabel);
freez(pEl);
}

void imageFreeList(struct image **pList)
/* Free a list of dynamically allocated image's */
{
struct image *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    imageFree(&el);
    }
*pList = NULL;
}

void imageOutput(struct image *el, FILE *f, char sep, char lastSep) 
/* Print out image.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->submissionSet);
fputc(sep,f);
fprintf(f, "%d", el->imageFile);
fputc(sep,f);
fprintf(f, "%d", el->imagePos);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->paneLabel);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->sectionSet);
fputc(sep,f);
fprintf(f, "%d", el->sectionIx);
fputc(sep,f);
fprintf(f, "%d", el->specimen);
fputc(sep,f);
fprintf(f, "%d", el->preparation);
fputc(lastSep,f);
}

void imageProbeStaticLoad(char **row, struct imageProbe *ret)
/* Load a row from imageProbe table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->image = sqlSigned(row[1]);
ret->probe = sqlSigned(row[2]);
ret->probeColor = sqlSigned(row[3]);
}

struct imageProbe *imageProbeLoad(char **row)
/* Load a imageProbe from row fetched with select * from imageProbe
 * from database.  Dispose of this with imageProbeFree(). */
{
struct imageProbe *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->image = sqlSigned(row[1]);
ret->probe = sqlSigned(row[2]);
ret->probeColor = sqlSigned(row[3]);
return ret;
}

struct imageProbe *imageProbeLoadAll(char *fileName) 
/* Load all imageProbe from a whitespace-separated file.
 * Dispose of this with imageProbeFreeList(). */
{
struct imageProbe *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = imageProbeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct imageProbe *imageProbeLoadAllByChar(char *fileName, char chopper) 
/* Load all imageProbe from a chopper separated file.
 * Dispose of this with imageProbeFreeList(). */
{
struct imageProbe *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = imageProbeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct imageProbe *imageProbeCommaIn(char **pS, struct imageProbe *ret)
/* Create a imageProbe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new imageProbe */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->image = sqlSignedComma(&s);
ret->probe = sqlSignedComma(&s);
ret->probeColor = sqlSignedComma(&s);
*pS = s;
return ret;
}

void imageProbeFree(struct imageProbe **pEl)
/* Free a single dynamically allocated imageProbe such as created
 * with imageProbeLoad(). */
{
struct imageProbe *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void imageProbeFreeList(struct imageProbe **pList)
/* Free a list of dynamically allocated imageProbe's */
{
struct imageProbe *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    imageProbeFree(&el);
    }
*pList = NULL;
}

void imageProbeOutput(struct imageProbe *el, FILE *f, char sep, char lastSep) 
/* Print out imageProbe.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->image);
fputc(sep,f);
fprintf(f, "%d", el->probe);
fputc(sep,f);
fprintf(f, "%d", el->probeColor);
fputc(lastSep,f);
}

void expressionPatternStaticLoad(char **row, struct expressionPattern *ret)
/* Load a row from expressionPattern table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->description = row[1];
}

struct expressionPattern *expressionPatternLoad(char **row)
/* Load a expressionPattern from row fetched with select * from expressionPattern
 * from database.  Dispose of this with expressionPatternFree(). */
{
struct expressionPattern *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->description = cloneString(row[1]);
return ret;
}

struct expressionPattern *expressionPatternLoadAll(char *fileName) 
/* Load all expressionPattern from a whitespace-separated file.
 * Dispose of this with expressionPatternFreeList(). */
{
struct expressionPattern *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = expressionPatternLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct expressionPattern *expressionPatternLoadAllByChar(char *fileName, char chopper) 
/* Load all expressionPattern from a chopper separated file.
 * Dispose of this with expressionPatternFreeList(). */
{
struct expressionPattern *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = expressionPatternLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct expressionPattern *expressionPatternCommaIn(char **pS, struct expressionPattern *ret)
/* Create a expressionPattern out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new expressionPattern */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void expressionPatternFree(struct expressionPattern **pEl)
/* Free a single dynamically allocated expressionPattern such as created
 * with expressionPatternLoad(). */
{
struct expressionPattern *el;

if ((el = *pEl) == NULL) return;
freeMem(el->description);
freez(pEl);
}

void expressionPatternFreeList(struct expressionPattern **pList)
/* Free a list of dynamically allocated expressionPattern's */
{
struct expressionPattern *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    expressionPatternFree(&el);
    }
*pList = NULL;
}

void expressionPatternOutput(struct expressionPattern *el, FILE *f, char sep, char lastSep) 
/* Print out expressionPattern.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void expressionLevelStaticLoad(char **row, struct expressionLevel *ret)
/* Load a row from expressionLevel table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->imageProbe = sqlSigned(row[0]);
ret->bodyPart = sqlSigned(row[1]);
ret->level = atof(row[2]);
ret->cellType = sqlSigned(row[3]);
ret->cellSubtype = sqlSigned(row[4]);
ret->expressionPattern = sqlSigned(row[5]);
}

struct expressionLevel *expressionLevelLoad(char **row)
/* Load a expressionLevel from row fetched with select * from expressionLevel
 * from database.  Dispose of this with expressionLevelFree(). */
{
struct expressionLevel *ret;

AllocVar(ret);
ret->imageProbe = sqlSigned(row[0]);
ret->bodyPart = sqlSigned(row[1]);
ret->level = atof(row[2]);
ret->cellType = sqlSigned(row[3]);
ret->cellSubtype = sqlSigned(row[4]);
ret->expressionPattern = sqlSigned(row[5]);
return ret;
}

struct expressionLevel *expressionLevelLoadAll(char *fileName) 
/* Load all expressionLevel from a whitespace-separated file.
 * Dispose of this with expressionLevelFreeList(). */
{
struct expressionLevel *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = expressionLevelLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct expressionLevel *expressionLevelLoadAllByChar(char *fileName, char chopper) 
/* Load all expressionLevel from a chopper separated file.
 * Dispose of this with expressionLevelFreeList(). */
{
struct expressionLevel *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = expressionLevelLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct expressionLevel *expressionLevelCommaIn(char **pS, struct expressionLevel *ret)
/* Create a expressionLevel out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new expressionLevel */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->imageProbe = sqlSignedComma(&s);
ret->bodyPart = sqlSignedComma(&s);
ret->level = sqlFloatComma(&s);
ret->cellType = sqlSignedComma(&s);
ret->cellSubtype = sqlSignedComma(&s);
ret->expressionPattern = sqlSignedComma(&s);
*pS = s;
return ret;
}

void expressionLevelFree(struct expressionLevel **pEl)
/* Free a single dynamically allocated expressionLevel such as created
 * with expressionLevelLoad(). */
{
struct expressionLevel *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void expressionLevelFreeList(struct expressionLevel **pList)
/* Free a list of dynamically allocated expressionLevel's */
{
struct expressionLevel *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    expressionLevelFree(&el);
    }
*pList = NULL;
}

void expressionLevelOutput(struct expressionLevel *el, FILE *f, char sep, char lastSep) 
/* Print out expressionLevel.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->imageProbe);
fputc(sep,f);
fprintf(f, "%d", el->bodyPart);
fputc(sep,f);
fprintf(f, "%g", el->level);
fputc(sep,f);
fprintf(f, "%d", el->cellType);
fputc(sep,f);
fprintf(f, "%d", el->cellSubtype);
fputc(sep,f);
fprintf(f, "%d", el->expressionPattern);
fputc(lastSep,f);
}

void lifeTimeStaticLoad(char **row, struct lifeTime *ret)
/* Load a row from lifeTime table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->taxon = sqlSigned(row[0]);
ret->birth = atof(row[1]);
ret->adult = atof(row[2]);
ret->death = atof(row[3]);
}

struct lifeTime *lifeTimeLoad(char **row)
/* Load a lifeTime from row fetched with select * from lifeTime
 * from database.  Dispose of this with lifeTimeFree(). */
{
struct lifeTime *ret;

AllocVar(ret);
ret->taxon = sqlSigned(row[0]);
ret->birth = atof(row[1]);
ret->adult = atof(row[2]);
ret->death = atof(row[3]);
return ret;
}

struct lifeTime *lifeTimeLoadAll(char *fileName) 
/* Load all lifeTime from a whitespace-separated file.
 * Dispose of this with lifeTimeFreeList(). */
{
struct lifeTime *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = lifeTimeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lifeTime *lifeTimeLoadAllByChar(char *fileName, char chopper) 
/* Load all lifeTime from a chopper separated file.
 * Dispose of this with lifeTimeFreeList(). */
{
struct lifeTime *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = lifeTimeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lifeTime *lifeTimeCommaIn(char **pS, struct lifeTime *ret)
/* Create a lifeTime out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lifeTime */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->taxon = sqlSignedComma(&s);
ret->birth = sqlFloatComma(&s);
ret->adult = sqlFloatComma(&s);
ret->death = sqlFloatComma(&s);
*pS = s;
return ret;
}

void lifeTimeFree(struct lifeTime **pEl)
/* Free a single dynamically allocated lifeTime such as created
 * with lifeTimeLoad(). */
{
struct lifeTime *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void lifeTimeFreeList(struct lifeTime **pList)
/* Free a list of dynamically allocated lifeTime's */
{
struct lifeTime *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    lifeTimeFree(&el);
    }
*pList = NULL;
}

void lifeTimeOutput(struct lifeTime *el, FILE *f, char sep, char lastSep) 
/* Print out lifeTime.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->taxon);
fputc(sep,f);
fprintf(f, "%g", el->birth);
fputc(sep,f);
fprintf(f, "%g", el->adult);
fputc(sep,f);
fprintf(f, "%g", el->death);
fputc(lastSep,f);
}

void lifeStageSchemeStaticLoad(char **row, struct lifeStageScheme *ret)
/* Load a row from lifeStageScheme table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->taxon = sqlSigned(row[1]);
ret->name = row[2];
}

struct lifeStageScheme *lifeStageSchemeLoad(char **row)
/* Load a lifeStageScheme from row fetched with select * from lifeStageScheme
 * from database.  Dispose of this with lifeStageSchemeFree(). */
{
struct lifeStageScheme *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->taxon = sqlSigned(row[1]);
ret->name = cloneString(row[2]);
return ret;
}

struct lifeStageScheme *lifeStageSchemeLoadAll(char *fileName) 
/* Load all lifeStageScheme from a whitespace-separated file.
 * Dispose of this with lifeStageSchemeFreeList(). */
{
struct lifeStageScheme *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = lifeStageSchemeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lifeStageScheme *lifeStageSchemeLoadAllByChar(char *fileName, char chopper) 
/* Load all lifeStageScheme from a chopper separated file.
 * Dispose of this with lifeStageSchemeFreeList(). */
{
struct lifeStageScheme *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = lifeStageSchemeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lifeStageScheme *lifeStageSchemeCommaIn(char **pS, struct lifeStageScheme *ret)
/* Create a lifeStageScheme out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lifeStageScheme */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->taxon = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void lifeStageSchemeFree(struct lifeStageScheme **pEl)
/* Free a single dynamically allocated lifeStageScheme such as created
 * with lifeStageSchemeLoad(). */
{
struct lifeStageScheme *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void lifeStageSchemeFreeList(struct lifeStageScheme **pList)
/* Free a list of dynamically allocated lifeStageScheme's */
{
struct lifeStageScheme *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    lifeStageSchemeFree(&el);
    }
*pList = NULL;
}

void lifeStageSchemeOutput(struct lifeStageScheme *el, FILE *f, char sep, char lastSep) 
/* Print out lifeStageScheme.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
fprintf(f, "%d", el->taxon);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void lifeStageStaticLoad(char **row, struct lifeStage *ret)
/* Load a row from lifeStage table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->lifeStageScheme = sqlSigned(row[0]);
ret->name = row[1];
ret->age = atof(row[2]);
ret->description = row[3];
}

struct lifeStage *lifeStageLoad(char **row)
/* Load a lifeStage from row fetched with select * from lifeStage
 * from database.  Dispose of this with lifeStageFree(). */
{
struct lifeStage *ret;

AllocVar(ret);
ret->lifeStageScheme = sqlSigned(row[0]);
ret->name = cloneString(row[1]);
ret->age = atof(row[2]);
ret->description = cloneString(row[3]);
return ret;
}

struct lifeStage *lifeStageLoadAll(char *fileName) 
/* Load all lifeStage from a whitespace-separated file.
 * Dispose of this with lifeStageFreeList(). */
{
struct lifeStage *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = lifeStageLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lifeStage *lifeStageLoadAllByChar(char *fileName, char chopper) 
/* Load all lifeStage from a chopper separated file.
 * Dispose of this with lifeStageFreeList(). */
{
struct lifeStage *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = lifeStageLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct lifeStage *lifeStageCommaIn(char **pS, struct lifeStage *ret)
/* Create a lifeStage out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lifeStage */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->lifeStageScheme = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->age = sqlFloatComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void lifeStageFree(struct lifeStage **pEl)
/* Free a single dynamically allocated lifeStage such as created
 * with lifeStageLoad(). */
{
struct lifeStage *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
freez(pEl);
}

void lifeStageFreeList(struct lifeStage **pList)
/* Free a list of dynamically allocated lifeStage's */
{
struct lifeStage *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    lifeStageFree(&el);
    }
*pList = NULL;
}

void lifeStageOutput(struct lifeStage *el, FILE *f, char sep, char lastSep) 
/* Print out lifeStage.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->lifeStageScheme);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->age);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

