/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.jstestdriver.FileInfo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JstdTestCase {
    private final List<FileInfo> dependencies;
    private final List<FileInfo> tests;
    private final List<FileInfo> plugins;

    public JstdTestCase(List<FileInfo> dependencies, List<FileInfo> tests, List<FileInfo> plugins) {
        this.dependencies = dependencies;
        this.tests = tests;
        this.plugins = plugins;
    }

    public List<FileInfo> getTests() {
        return this.tests;
    }

    public List<FileInfo> getDependencies() {
        return this.dependencies;
    }

    public List<FileInfo> getPlugins() {
        return this.plugins;
    }

    public Set<FileInfo> toFileSet() {
        LinkedHashSet<FileInfo> fileSet = Sets.newLinkedHashSet(this.plugins);
        fileSet.addAll(this.dependencies);
        fileSet.addAll(this.tests);
        return fileSet;
    }

    public JstdTestCase updatePlugins(List<FileInfo> plugins) {
        ArrayList<FileInfo> combined = Lists.newArrayListWithExpectedSize(plugins.size() + this.plugins.size());
        combined.addAll(this.plugins);
        combined.addAll(plugins);
        return new JstdTestCase(this.dependencies, this.tests, combined);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependencies == null ? 0 : ((Object)this.dependencies).hashCode());
        result = 31 * result + (this.plugins == null ? 0 : ((Object)this.plugins).hashCode());
        result = 31 * result + (this.tests == null ? 0 : ((Object)this.tests).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JstdTestCase other = (JstdTestCase)obj;
        if (this.dependencies == null ? other.dependencies != null : !((Object)this.dependencies).equals(other.dependencies)) {
            return false;
        }
        if (this.plugins == null ? other.plugins != null : !((Object)this.plugins).equals(other.plugins)) {
            return false;
        }
        return !(this.tests == null ? other.tests != null : !((Object)this.tests).equals(other.tests));
    }

    public String toString() {
        return "JstdTestCase [dependencies=" + this.dependencies + ", plugins=" + this.plugins + ", tests=" + this.tests + "]";
    }
}

