/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.Lock;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.annotations.ResponseWriter;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSetGetHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileSetGetHandler.class);
    private static final int HEARTBEAT_TIMEOUT = 2000;
    private final HttpServletRequest request;
    private final PrintWriter writer;
    private final CapturedBrowsers capturedBrowsers;

    @Inject
    public FileSetGetHandler(HttpServletRequest request, @ResponseWriter PrintWriter writer, CapturedBrowsers capturedBrowsers) {
        this.request = request;
        this.writer = writer;
        this.capturedBrowsers = capturedBrowsers;
    }

    public void handleIt() throws IOException {
        String id = this.request.getParameter("id");
        String session = this.request.getParameter("session");
        String sessionId = this.request.getParameter("sessionId");
        if (session == null && sessionId != null) {
            this.sessionHeartBeat(id, sessionId);
        } else if (session.equals("start")) {
            this.startSession(id, this.writer);
        } else if (session.equals("stop")) {
            this.stopSession(id, sessionId, this.writer);
        }
    }

    private void sessionHeartBeat(String id, String sessionId) {
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        if (browser == null) {
            logger.error("heartbeat to a dead session");
            return;
        }
        Lock lock = browser.getLock();
        if (lock.getSessionId().equals(sessionId)) {
            lock.setLastHeartBeat(new Date().getTime());
        } else {
            logger.error("unknown client with {}", (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSession(String id, String sessionId, PrintWriter writer) {
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        Lock lock = browser.getLock();
        try {
            lock.unlock(sessionId);
            browser.clearCommandRunning();
        }
        finally {
            writer.flush();
        }
    }

    public void startSession(String id, PrintWriter writer) {
        logger.debug("trying to start session for {}", (Object)id);
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        Lock lock = browser.getLock();
        String sessionId = UUID.randomUUID().toString();
        if (lock.tryLock(sessionId)) {
            logger.debug("got session lock {} for {}", (Object)sessionId, (Object)id);
            writer.write(sessionId);
        } else {
            logger.debug("checking session status for {}", (Object)id);
            if (!browser.isCommandRunning() && browser.peekCommand() == null || System.currentTimeMillis() - lock.getLastHeartBeat() > 2000L) {
                logger.debug("forcing unlock for {}", (Object)id);
                lock.forceUnlock();
                SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(id);
                slaveBrowser.clearCommandRunning();
                slaveBrowser.clearResponseQueue();
                writer.write(lock.tryLock(sessionId) ? sessionId : "FAILED");
            } else {
                logger.debug("session unvailable for {}", (Object)id);
                writer.write("FAILED");
            }
        }
        writer.flush();
    }
}

