/* dvBed.c was originally generated by the autoSql program, which also 
 * generated dvBed.h and dvBed.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "dvBed.h"


void dvBedStaticLoad(char **row, struct dvBed *ret)
/* Load a row from dvBed table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
}

struct dvBed *dvBedLoad(char **row)
/* Load a dvBed from row fetched with select * from dvBed
 * from database.  Dispose of this with dvBedFree(). */
{
struct dvBed *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
return ret;
}

struct dvBed *dvBedLoadAll(char *fileName) 
/* Load all dvBed from a whitespace-separated file.
 * Dispose of this with dvBedFreeList(). */
{
struct dvBed *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = dvBedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dvBed *dvBedLoadAllByChar(char *fileName, char chopper) 
/* Load all dvBed from a chopper separated file.
 * Dispose of this with dvBedFreeList(). */
{
struct dvBed *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = dvBedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dvBed *dvBedCommaIn(char **pS, struct dvBed *ret)
/* Create a dvBed out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dvBed */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
*pS = s;
return ret;
}

void dvBedFree(struct dvBed **pEl)
/* Free a single dynamically allocated dvBed such as created
 * with dvBedLoad(). */
{
struct dvBed *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void dvBedFreeList(struct dvBed **pList)
/* Free a list of dynamically allocated dvBed's */
{
struct dvBed *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    dvBedFree(&el);
    }
*pList = NULL;
}

void dvBedOutput(struct dvBed *el, FILE *f, char sep, char lastSep) 
/* Print out dvBed.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

