/* wgRna.c was originally generated by the autoSql program, which also 
 * generated wgRna.h and wgRna.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "wgRna.h"


void wgRnaStaticLoad(char **row, struct wgRna *ret)
/* Load a row from wgRna table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->bin = sqlSigned(row[0]);
ret->chrom = row[1];
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = row[4];
ret->score = sqlUnsigned(row[5]);
strcpy(ret->strand, row[6]);
ret->thickStart = sqlUnsigned(row[7]);
ret->thickEnd = sqlUnsigned(row[8]);
ret->type = row[9];
}

struct wgRna *wgRnaLoad(char **row)
/* Load a wgRna from row fetched with select * from wgRna
 * from database.  Dispose of this with wgRnaFree(). */
{
struct wgRna *ret;

AllocVar(ret);
ret->bin = sqlSigned(row[0]);
ret->chrom = cloneString(row[1]);
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = cloneString(row[4]);
ret->score = sqlUnsigned(row[5]);
strcpy(ret->strand, row[6]);
ret->thickStart = sqlUnsigned(row[7]);
ret->thickEnd = sqlUnsigned(row[8]);
ret->type = cloneString(row[9]);
return ret;
}

struct wgRna *wgRnaLoadAll(char *fileName) 
/* Load all wgRna from a whitespace-separated file.
 * Dispose of this with wgRnaFreeList(). */
{
struct wgRna *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = wgRnaLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgRna *wgRnaLoadAllByChar(char *fileName, char chopper) 
/* Load all wgRna from a chopper separated file.
 * Dispose of this with wgRnaFreeList(). */
{
struct wgRna *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = wgRnaLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct wgRna *wgRnaCommaIn(char **pS, struct wgRna *ret)
/* Create a wgRna out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new wgRna */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->bin = sqlSignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->type = sqlStringComma(&s);
*pS = s;
return ret;
}

void wgRnaFree(struct wgRna **pEl)
/* Free a single dynamically allocated wgRna such as created
 * with wgRnaLoad(). */
{
struct wgRna *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->type);
freez(pEl);
}

void wgRnaFreeList(struct wgRna **pList)
/* Free a list of dynamically allocated wgRna's */
{
struct wgRna *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    wgRnaFree(&el);
    }
*pList = NULL;
}

void wgRnaOutput(struct wgRna *el, FILE *f, char sep, char lastSep) 
/* Print out wgRna.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->bin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

