/* models.h was originally generated by the autoSql program, which also 
 * generated models.c and models.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef MODELS_H
#define MODELS_H

#define QUAKESAMPLE_NUM_COLS 12

extern char *quakeSampleCommaSepFieldNames;

struct quakeSample
/* Sample from quake lab */
    {
    struct quakeSample *next;  /* Next in singly linked list. */
    char *date;	/* DD/MM/YY format date string */
    char *subdir;	/* Subdirectory where files live */
    char *fluidPlateAcc;	/* Shorter 5 char accession corresponding to plate? */
    unsigned unknown1;	/* Seems to be number 1-8 with some gaps */
    char *seqFormat;	/* Form like 151 (8) (8) 151 or 101 (6) 101 */
    char *sequencer;	/* Looks like a sequencing machine id */
    char *sample;	/* Looks like a unique ID for each sample */
    char *user;	/* User name */
    char *lab;	/* Lab name */
    char *ilAcc;	/* SOme sort of accession starting with IL */
    char *captureArrayBarcode;	/* Seems to vary in lock-step with ilAcc */
    char *cellPos;	/* Position of cell in plate I think */
    };

void quakeSampleStaticLoad(char **row, struct quakeSample *ret);
/* Load a row from quakeSample table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct quakeSample *quakeSampleLoad(char **row);
/* Load a quakeSample from row fetched with select * from quakeSample
 * from database.  Dispose of this with quakeSampleFree(). */

struct quakeSample *quakeSampleLoadAll(char *fileName);
/* Load all quakeSample from whitespace-separated file.
 * Dispose of this with quakeSampleFreeList(). */

struct quakeSample *quakeSampleLoadAllByChar(char *fileName, char chopper);
/* Load all quakeSample from chopper separated file.
 * Dispose of this with quakeSampleFreeList(). */

#define quakeSampleLoadAllByTab(a) quakeSampleLoadAllByChar(a, '\t');
/* Load all quakeSample from tab separated file.
 * Dispose of this with quakeSampleFreeList(). */

struct quakeSample *quakeSampleCommaIn(char **pS, struct quakeSample *ret);
/* Create a quakeSample out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new quakeSample */

void quakeSampleFree(struct quakeSample **pEl);
/* Free a single dynamically allocated quakeSample such as created
 * with quakeSampleLoad(). */

void quakeSampleFreeList(struct quakeSample **pList);
/* Free a list of dynamically allocated quakeSample's */

void quakeSampleOutput(struct quakeSample *el, FILE *f, char sep, char lastSep);
/* Print out quakeSample.  Separate fields with sep. Follow last field with lastSep. */

#define quakeSampleTabOut(el,f) quakeSampleOutput(el,f,'\t','\n');
/* Print out quakeSample as a line in a tab-separated file. */

#define quakeSampleCommaOut(el,f) quakeSampleOutput(el,f,',',',');
/* Print out quakeSample as a comma separated list including final comma. */

#define QUAKECHIP_NUM_COLS 15

extern char *quakeChipCommaSepFieldNames;

struct quakeChip
/* A microfluidics chip from quake lab */
    {
    struct quakeChip *next;  /* Next in singly linked list. */
    char *captureArrayBarcode;	/* Long unique id */
    char *date;	/* MM/DD/YY format */
    char *machineName;	/* Name of machine run on */
    char *user;	/* User name */
    char *lab;	/* Lab */
    char *sampleType;	/* Overall type of cell */
    char *tissue;	/* Tissue or organ */
    char *species;	/* M. musculus, etc */
    char *strain;	/* Black 6 etc */
    char *age;	/* Adult, etc */
    char *targetCell;	/* Epithelium, etc */
    char *sortMethod;	/* FACS usually */
    char *markers;	/* Space delimited markers like CD45 etc */
    char *attiRun;	/* Seems to include data and other info */
    char *description;	/* Typically not very descriptive.... */
    };

void quakeChipStaticLoad(char **row, struct quakeChip *ret);
/* Load a row from quakeChip table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct quakeChip *quakeChipLoad(char **row);
/* Load a quakeChip from row fetched with select * from quakeChip
 * from database.  Dispose of this with quakeChipFree(). */

struct quakeChip *quakeChipLoadAll(char *fileName);
/* Load all quakeChip from whitespace-separated file.
 * Dispose of this with quakeChipFreeList(). */

struct quakeChip *quakeChipLoadAllByChar(char *fileName, char chopper);
/* Load all quakeChip from chopper separated file.
 * Dispose of this with quakeChipFreeList(). */

#define quakeChipLoadAllByTab(a) quakeChipLoadAllByChar(a, '\t');
/* Load all quakeChip from tab separated file.
 * Dispose of this with quakeChipFreeList(). */

struct quakeChip *quakeChipCommaIn(char **pS, struct quakeChip *ret);
/* Create a quakeChip out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new quakeChip */

void quakeChipFree(struct quakeChip **pEl);
/* Free a single dynamically allocated quakeChip such as created
 * with quakeChipLoad(). */

void quakeChipFreeList(struct quakeChip **pList);
/* Free a list of dynamically allocated quakeChip's */

void quakeChipOutput(struct quakeChip *el, FILE *f, char sep, char lastSep);
/* Print out quakeChip.  Separate fields with sep. Follow last field with lastSep. */

#define quakeChipTabOut(el,f) quakeChipOutput(el,f,'\t','\n');
/* Print out quakeChip as a line in a tab-separated file. */

#define quakeChipCommaOut(el,f) quakeChipOutput(el,f,',',',');
/* Print out quakeChip as a comma separated list including final comma. */

#define QUAKESHEET_NUM_COLS 10

extern char *quakeSheetCommaSepFieldNames;

struct quakeSheet
/* SampleSheet file info */
    {
    struct quakeSheet *next;  /* Next in singly linked list. */
    char *fcid;	/* Flow cell ID */
    int lane;	/* Sequencing lane - small number */
    char *sampleId;	/* Same as quakeSample.sample */
    char *sampleRef;	/* Always SampleRef? */
    char *seqIndex;	/* Nucleotides used to separate out multiplexing in lane */
    char *description;	/* Looks like some sort of IL # */
    char *control;	/* N */
    char *recipe;	/* Recipe */
    char *operator;	/* GM? */
    char *SampleProject;	/* Looks like this actually has operator */
    };

void quakeSheetStaticLoad(char **row, struct quakeSheet *ret);
/* Load a row from quakeSheet table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct quakeSheet *quakeSheetLoad(char **row);
/* Load a quakeSheet from row fetched with select * from quakeSheet
 * from database.  Dispose of this with quakeSheetFree(). */

struct quakeSheet *quakeSheetLoadAll(char *fileName);
/* Load all quakeSheet from whitespace-separated file.
 * Dispose of this with quakeSheetFreeList(). */

struct quakeSheet *quakeSheetLoadAllByChar(char *fileName, char chopper);
/* Load all quakeSheet from chopper separated file.
 * Dispose of this with quakeSheetFreeList(). */

#define quakeSheetLoadAllByTab(a) quakeSheetLoadAllByChar(a, '\t');
/* Load all quakeSheet from tab separated file.
 * Dispose of this with quakeSheetFreeList(). */

struct quakeSheet *quakeSheetCommaIn(char **pS, struct quakeSheet *ret);
/* Create a quakeSheet out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new quakeSheet */

void quakeSheetFree(struct quakeSheet **pEl);
/* Free a single dynamically allocated quakeSheet such as created
 * with quakeSheetLoad(). */

void quakeSheetFreeList(struct quakeSheet **pList);
/* Free a list of dynamically allocated quakeSheet's */

void quakeSheetOutput(struct quakeSheet *el, FILE *f, char sep, char lastSep);
/* Print out quakeSheet.  Separate fields with sep. Follow last field with lastSep. */

#define quakeSheetTabOut(el,f) quakeSheetOutput(el,f,'\t','\n');
/* Print out quakeSheet as a line in a tab-separated file. */

#define quakeSheetCommaOut(el,f) quakeSheetOutput(el,f,',',',');
/* Print out quakeSheet as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* MODELS_H */

