/* bacCloneXRef.h was originally generated by the autoSql program, which also 
 * generated bacCloneXRef.c and bacCloneXRef.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef BACCLONEXREF_H
#define BACCLONEXREF_H

#define BACCLONEXREF_NUM_COLS 9

struct bacCloneXRef
/* BAC clones and corresponding STS information */
    {
    struct bacCloneXRef *next;  /* Next in singly linked list. */
    char *name;	/* External name for BAC clone */
    char *intName;	/* Internal Sanger FPC name */
    char *chroms;	/* Chromosome(s) to which BAC is mapped by BLAT */
    char *genbank;	/* Genbank accession for the BAC Clone */
    char *sangerName;	/* Sanger STS name */
    unsigned relationship;	/* Relationship type - method of finding STS */
    char *uniStsId;	/* UniSTS ID(s) for STS */
    char *leftPrimer;	/* STS 5' primer sequence */
    char *rightPrimer;	/* STS 3' primer sequence */
    };

void bacCloneXRefStaticLoad(char **row, struct bacCloneXRef *ret);
/* Load a row from bacCloneXRef table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bacCloneXRef *bacCloneXRefLoad(char **row);
/* Load a bacCloneXRef from row fetched with select * from bacCloneXRef
 * from database.  Dispose of this with bacCloneXRefFree(). */

struct bacCloneXRef *bacCloneXRefLoadAll(char *fileName);
/* Load all bacCloneXRef from whitespace-separated file.
 * Dispose of this with bacCloneXRefFreeList(). */

struct bacCloneXRef *bacCloneXRefLoadAllByChar(char *fileName, char chopper);
/* Load all bacCloneXRef from chopper separated file.
 * Dispose of this with bacCloneXRefFreeList(). */

#define bacCloneXRefLoadAllByTab(a) bacCloneXRefLoadAllByChar(a, '\t');
/* Load all bacCloneXRef from tab separated file.
 * Dispose of this with bacCloneXRefFreeList(). */

struct bacCloneXRef *bacCloneXRefCommaIn(char **pS, struct bacCloneXRef *ret);
/* Create a bacCloneXRef out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bacCloneXRef */

void bacCloneXRefFree(struct bacCloneXRef **pEl);
/* Free a single dynamically allocated bacCloneXRef such as created
 * with bacCloneXRefLoad(). */

void bacCloneXRefFreeList(struct bacCloneXRef **pList);
/* Free a list of dynamically allocated bacCloneXRef's */

void bacCloneXRefOutput(struct bacCloneXRef *el, FILE *f, char sep, char lastSep);
/* Print out bacCloneXRef.  Separate fields with sep. Follow last field with lastSep. */

#define bacCloneXRefTabOut(el,f) bacCloneXRefOutput(el,f,'\t','\n');
/* Print out bacCloneXRef as a line in a tab-separated file. */

#define bacCloneXRefCommaOut(el,f) bacCloneXRefOutput(el,f,',',',');
/* Print out bacCloneXRef as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BACCLONEXREF_H */

