/* blastzNet.h was originally generated by the autoSql program, which also 
 * generated blastzNet.c and blastzNet.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef BLASTZNET_H
#define BLASTZNET_H

struct blastzNet
/* blastz netting file  */
    {
    struct blastzNet *next;  /* Next in singly linked list. */
    char *chrom;	/* Human Chrom */
    unsigned chromStart;	/* Start on Human */
    unsigned chromEnd;	/* End on Human */
    char *name;	/* Mouse Chromosome */
    unsigned score;	/* score always zero */
    char strand[2];	/* + direction matches - opposite */
    unsigned thickStart;	/* Start on Human */
    unsigned thickEnd;	/* End on Human */
    };

void blastzNetStaticLoad(char **row, struct blastzNet *ret);
/* Load a row from blastzNet table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct blastzNet *blastzNetLoad(char **row);
/* Load a blastzNet from row fetched with select * from blastzNet
 * from database.  Dispose of this with blastzNetFree(). */

struct blastzNet *blastzNetLoadAll(char *fileName);
/* Load all blastzNet from a tab-separated file.
 * Dispose of this with blastzNetFreeList(). */

struct blastzNet *blastzNetLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all blastzNet from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with blastzNetFreeList(). */

struct blastzNet *blastzNetCommaIn(char **pS, struct blastzNet *ret);
/* Create a blastzNet out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new blastzNet */

void blastzNetFree(struct blastzNet **pEl);
/* Free a single dynamically allocated blastzNet such as created
 * with blastzNetLoad(). */

void blastzNetFreeList(struct blastzNet **pList);
/* Free a list of dynamically allocated blastzNet's */

void blastzNetOutput(struct blastzNet *el, FILE *f, char sep, char lastSep);
/* Print out blastzNet.  Separate fields with sep. Follow last field with lastSep. */

#define blastzNetTabOut(el,f) blastzNetOutput(el,f,'\t','\n');
/* Print out blastzNet as a line in a tab-separated file. */

#define blastzNetCommaOut(el,f) blastzNetOutput(el,f,',',',');
/* Print out blastzNet as a comma separated list including final comma. */

#endif /* BLASTZNET_H */

