/* makeItemsItem.h was originally generated by the autoSql program, which also
 * generated makeItemsItem.c and makeItemsItem.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef MAKEITEMSITEM_H
#define MAKEITEMSITEM_H

#include "jksql.h"
#include "asParse.h"
#define MAKEITEMSITEM_NUM_COLS 12

struct makeItemsItem
/* An item in a makeItems type track. */
    {
    struct makeItemsItem *next;  /* Next in singly linked list. */
    unsigned bin;	/* Bin for range index */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item - up to 16 chars */
    unsigned score;	/* 0-1000.  Higher numbers are darker. */
    char strand[2];	/* + or - for strand */
    unsigned thickStart;	/* Start of thick part */
    unsigned thickEnd;	/* End position of thick part */
    unsigned itemRgb;	/* RGB 8 bits each as in bed */
    char *description;	/* Longer item description */
    unsigned id;	/* Unique ID for item */
    };

void makeItemsItemStaticLoad(char **row, struct makeItemsItem *ret);
/* Load a row from makeItemsItem table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct makeItemsItem *makeItemsItemLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all makeItemsItem from table that satisfy the query given.
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something =
 * anotherTable.something'.
 * Dispose of this with makeItemsItemFreeList(). */

void makeItemsItemSaveToDb(struct sqlConnection *conn, struct makeItemsItem *el, char *tableName, int updateSize);
/* Save makeItemsItem as a row to the table specified by tableName.
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct makeItemsItem *makeItemsItemLoad(char **row);
/* Load a makeItemsItem from row fetched with select * from makeItemsItem
 * from database.  Dispose of this with makeItemsItemFree(). */

struct makeItemsItem *makeItemsItemLoadAll(char *fileName);
/* Load all makeItemsItem from whitespace-separated file.
 * Dispose of this with makeItemsItemFreeList(). */

struct makeItemsItem *makeItemsItemLoadAllByChar(char *fileName, char chopper);
/* Load all makeItemsItem from chopper separated file.
 * Dispose of this with makeItemsItemFreeList(). */

#define makeItemsItemLoadAllByTab(a) makeItemsItemLoadAllByChar(a, '\t');
/* Load all makeItemsItem from tab separated file.
 * Dispose of this with makeItemsItemFreeList(). */

struct makeItemsItem *makeItemsItemCommaIn(char **pS, struct makeItemsItem *ret);
/* Create a makeItemsItem out of a comma separated string.
 * This will fill in ret if non-null, otherwise will
 * return a new makeItemsItem */

void makeItemsItemFree(struct makeItemsItem **pEl);
/* Free a single dynamically allocated makeItemsItem such as created
 * with makeItemsItemLoad(). */

void makeItemsItemFreeList(struct makeItemsItem **pList);
/* Free a list of dynamically allocated makeItemsItem's */

void makeItemsItemOutput(struct makeItemsItem *el, FILE *f, char sep, char lastSep);
/* Print out makeItemsItem.  Separate fields with sep. Follow last field with lastSep. */

#define makeItemsItemTabOut(el,f) makeItemsItemOutput(el,f,'\t','\n');
/* Print out makeItemsItem as a line in a tab-separated file. */

#define makeItemsItemCommaOut(el,f) makeItemsItemOutput(el,f,',',',');
/* Print out makeItemsItem as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct asObject *makeItemsItemAsObj();
// Return asObject describing fields of makeItemsItem

#endif /* MAKEITEMSITEM_H */

