/* pscreen.h was originally generated by the autoSql program, which also 
 * generated pscreen.c and pscreen.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef PSCREEN_H
#define PSCREEN_H

#define PSCREEN_NUM_COLS 9

struct pscreen
/* P-Screen (BDGP Gene Disruption Project) P el. insertion locations/genes */
    {
    struct pscreen *next;  /* Next in singly linked list. */
    char *chrom;	/* chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item (mutant strain with P el. insert here) */
    unsigned score;	/* Score from 0-1000 (placeholder! for bed 6 compat) */
    char strand[2];	/* + or - */
    unsigned stockNumber;	/* Mutant strain stock number, for ordering */
    unsigned geneCount;	/* Number of genes disrupted by this insert */
    char **geneIds;	/* IDs of genes disrupted */
    };

struct pscreen *pscreenLoad(char **row);
/* Load a pscreen from row fetched with select * from pscreen
 * from database.  Dispose of this with pscreenFree(). */

struct pscreen *pscreenLoadAll(char *fileName);
/* Load all pscreen from whitespace-separated file.
 * Dispose of this with pscreenFreeList(). */

struct pscreen *pscreenLoadAllByChar(char *fileName, char chopper);
/* Load all pscreen from chopper separated file.
 * Dispose of this with pscreenFreeList(). */

#define pscreenLoadAllByTab(a) pscreenLoadAllByChar(a, '\t');
/* Load all pscreen from tab separated file.
 * Dispose of this with pscreenFreeList(). */

struct pscreen *pscreenCommaIn(char **pS, struct pscreen *ret);
/* Create a pscreen out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new pscreen */

void pscreenFree(struct pscreen **pEl);
/* Free a single dynamically allocated pscreen such as created
 * with pscreenLoad(). */

void pscreenFreeList(struct pscreen **pList);
/* Free a list of dynamically allocated pscreen's */

void pscreenOutput(struct pscreen *el, FILE *f, char sep, char lastSep);
/* Print out pscreen.  Separate fields with sep. Follow last field with lastSep. */

#define pscreenTabOut(el,f) pscreenOutput(el,f,'\t','\n');
/* Print out pscreen as a line in a tab-separated file. */

#define pscreenCommaOut(el,f) pscreenOutput(el,f,',',',');
/* Print out pscreen as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* PSCREEN_H */

