/* gcPercent.c was originally generated by the autoSql program, which also 
 * generated gcPercent.h and gcPercent.sql.  This module links the database and the RAM 
 * representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "jksql.h"
#include "gcPercent.h"


void gcPercentStaticLoad(char **row, struct gcPercent *ret)
/* Load a row from gcPercent table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->gcPpt = sqlUnsigned(row[4]);
}

struct gcPercent *gcPercentLoad(char **row)
/* Load a gcPercent from row fetched with select * from gcPercent
 * from database.  Dispose of this with gcPercentFree(). */
{
struct gcPercent *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->gcPpt = sqlUnsigned(row[4]);
return ret;
}

struct gcPercent *gcPercentCommaIn(char **pS, struct gcPercent *ret)
/* Create a gcPercent out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gcPercent */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->gcPpt = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void gcPercentFree(struct gcPercent **pEl)
/* Free a single dynamically allocated gcPercent such as created
 * with gcPercentLoad(). */
{
struct gcPercent *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void gcPercentFreeList(struct gcPercent **pList)
/* Free a list of dynamically allocated gcPercent's */
{
struct gcPercent *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gcPercentFree(&el);
    }
*pList = NULL;
}

void gcPercentOutput(struct gcPercent *el, FILE *f, char sep, char lastSep) 
/* Print out gcPercent.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->gcPpt);
fputc(lastSep,f);
}

