/* geneCheckDetails.c was originally generated by the autoSql program, which also 
 * generated geneCheckDetails.h and geneCheckDetails.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "geneCheckDetails.h"


void geneCheckDetailsStaticLoad(char **row, struct geneCheckDetails *ret)
/* Load a row from geneCheckDetails table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->acc = row[0];
ret->problem = row[1];
ret->info = row[2];
ret->chr = row[3];
ret->chrStart = sqlUnsigned(row[4]);
ret->chrEnd = sqlUnsigned(row[5]);
}

struct geneCheckDetails *geneCheckDetailsLoad(char **row)
/* Load a geneCheckDetails from row fetched with select * from geneCheckDetails
 * from database.  Dispose of this with geneCheckDetailsFree(). */
{
struct geneCheckDetails *ret;

AllocVar(ret);
ret->acc = cloneString(row[0]);
ret->problem = cloneString(row[1]);
ret->info = cloneString(row[2]);
ret->chr = cloneString(row[3]);
ret->chrStart = sqlUnsigned(row[4]);
ret->chrEnd = sqlUnsigned(row[5]);
return ret;
}

struct geneCheckDetails *geneCheckDetailsLoadAll(char *fileName) 
/* Load all geneCheckDetails from a whitespace-separated file.
 * Dispose of this with geneCheckDetailsFreeList(). */
{
struct geneCheckDetails *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = geneCheckDetailsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneCheckDetails *geneCheckDetailsLoadAllByChar(char *fileName, char chopper) 
/* Load all geneCheckDetails from a chopper separated file.
 * Dispose of this with geneCheckDetailsFreeList(). */
{
struct geneCheckDetails *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = geneCheckDetailsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct geneCheckDetails *geneCheckDetailsCommaIn(char **pS, struct geneCheckDetails *ret)
/* Create a geneCheckDetails out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneCheckDetails */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->acc = sqlStringComma(&s);
ret->problem = sqlStringComma(&s);
ret->info = sqlStringComma(&s);
ret->chr = sqlStringComma(&s);
ret->chrStart = sqlUnsignedComma(&s);
ret->chrEnd = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void geneCheckDetailsFree(struct geneCheckDetails **pEl)
/* Free a single dynamically allocated geneCheckDetails such as created
 * with geneCheckDetailsLoad(). */
{
struct geneCheckDetails *el;

if ((el = *pEl) == NULL) return;
freeMem(el->acc);
freeMem(el->problem);
freeMem(el->info);
freeMem(el->chr);
freez(pEl);
}

void geneCheckDetailsFreeList(struct geneCheckDetails **pList)
/* Free a list of dynamically allocated geneCheckDetails's */
{
struct geneCheckDetails *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    geneCheckDetailsFree(&el);
    }
*pList = NULL;
}

void geneCheckDetailsOutput(struct geneCheckDetails *el, FILE *f, char sep, char lastSep) 
/* Print out geneCheckDetails.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->problem);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->info);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chrStart);
fputc(sep,f);
fprintf(f, "%u", el->chrEnd);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

