# llaInfo.sql was originally generated by the autoSql program, which also 
# generated llaInfo.c and llaInfo.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Extra information for a lowe lab array
CREATE TABLE llaInfo (
    name varchar(255) not null,	# Name of primer pair
    type varchar(255) not null,	# Type of primer pair (ORF or intergenic)
    SnTm float not null,	# Sense primer annealing temp
    SnGc float not null,	# Sense primer annealing temp
    SnSc float not null,	# Sense primer self-complementarity score
    Sn3pSc float not null,	# Sense primer 3-prime self-complementarity score
    AsnTm float not null,	# Antisense primer annealing temp
    AsnGc float not null,	# Antisense primer annealing temp
    AsnSc float not null,	# Antisense primer self-complementarity score
    Asn3pSc float not null,	# Antisense primer 3-prime self-complementarity score
    prodLen int unsigned not null,	# PCR product length
    ORFLen int unsigned not null,	# Source ORF length
    meltTm float not null,	# PCR melting temperature
    frcc float not null,	# Forward+reverse primer cross complementarity
    fr3pcc float not null,	# 3-prime forward+reverse primer cross complementarity
    SnSeq longblob not null,	# Sense primer sequence
    AsnSeq longblob not null,	# Antisense primer sequence
    numCorrs int unsigned not null,	# Number of correlations stored
    corrNames longblob not null,	# Names of correlated genes
    corrs longblob not null,	# Correlations
              #Indices
    PRIMARY KEY(name)
);
