table lrg
"Locus Reference Genomic regions"
    (
    string chrom;      "Reference assembly chromosome or scaffold"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    string name;       "LRG ID"
    uint   score;      "Placeholder for BED format compatibility (0)"
    char[1] strand;    "Orientation of LRG to reference assembly: + or -"
    uint thickStart;   "Placeholder for BED format compatibility (same as chromStart)"
    uint thickEnd;     "Placeholder for BED format compatibility (same as chromEnd)"
    uint reserved;     "Placeholder for BED format compatibility (0)"
    int blockCount;    "Number of gapless aligned blocks"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"
    lstring mismatches; "List of bases that differ between LRG and reference assembly"
    lstring indels;     "List of insertions/deletions in LRG and reference assembly"
    uint lrgSize;       "Length in bases of LRG sequence"
    int hgncId;         "Numeric HGNC gene identifier"
    string hgncSymbol;  "HGNC gene symbol"
    string ncbiAcc;     "NCBI accession of LRG sequence"
    lstring lrgSource;  "Source of LRG sequence"
    lstring lrgSourceUrl; "URL of lrgSource"
    string creationDate;  "Date on which this sequence was added as a LRG"
    )
