/* rmskJoined.c was originally generated by the autoSql program, which also 
 * generated rmskJoined.h and rmskJoined.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "rmskJoined.h"


struct rmskJoined *rmskJoinedLoad(char **row)
/* Load a rmskJoined from row fetched with select * from rmskJoined
 * from database.  Dispose of this with rmskJoinedFree(). */
{
struct rmskJoined *ret;

AllocVar(ret);
ret->blockCount = sqlSigned(row[9]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->alignStart = sqlUnsigned(row[6]);
ret->alignEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
{
int sizeOne;
sqlSignedDynamicArray(row[10], &ret->blockSizes, &sizeOne);
assert(sizeOne == ret->blockCount);
}
{
int sizeOne;
sqlSignedDynamicArray(row[11], &ret->blockRelStarts, &sizeOne);
assert(sizeOne == ret->blockCount);
}
ret->id = cloneString(row[12]);
return ret;
}

struct rmskJoined *rmskJoinedLoadAll(char *fileName) 
/* Load all rmskJoined from a whitespace-separated file.
 * Dispose of this with rmskJoinedFreeList(). */
{
struct rmskJoined *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = rmskJoinedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct rmskJoined *rmskJoinedLoadAllByChar(char *fileName, char chopper) 
/* Load all rmskJoined from a chopper separated file.
 * Dispose of this with rmskJoinedFreeList(). */
{
struct rmskJoined *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = rmskJoinedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct rmskJoined *rmskJoinedCommaIn(char **pS, struct rmskJoined *ret)
/* Create a rmskJoined out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rmskJoined */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->alignStart = sqlUnsignedComma(&s);
ret->alignEnd = sqlUnsignedComma(&s);
ret->reserved = sqlUnsignedComma(&s);
ret->blockCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->blockSizes, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->blockSizes[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->blockRelStarts, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->blockRelStarts[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->id = sqlStringComma(&s);
*pS = s;
return ret;
}

void rmskJoinedFree(struct rmskJoined **pEl)
/* Free a single dynamically allocated rmskJoined such as created
 * with rmskJoinedLoad(). */
{
struct rmskJoined *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->blockSizes);
freeMem(el->blockRelStarts);
freeMem(el->id);
freez(pEl);
}

void rmskJoinedFreeList(struct rmskJoined **pList)
/* Free a list of dynamically allocated rmskJoined's */
{
struct rmskJoined *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    rmskJoinedFree(&el);
    }
*pList = NULL;
}

void rmskJoinedOutput(struct rmskJoined *el, FILE *f, char sep, char lastSep) 
/* Print out rmskJoined.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->alignStart);
fputc(sep,f);
fprintf(f, "%u", el->alignEnd);
fputc(sep,f);
fprintf(f, "%u", el->reserved);
fputc(sep,f);
fprintf(f, "%d", el->blockCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->blockSizes[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->blockRelStarts[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */
