/* rankPropProt.h was originally generated by the autoSql program, which also 
 * generated rankPropProt.c and rankPropProt.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef RANKPROPPROT_H
#define RANKPROPPROT_H

#define RANKPROPPROT_NUM_COLS 5

struct rankPropProt
/* Output RankProp protein ranking for a pair of proteins. this is the output of build process, with protein ids, not the table */
    {
    struct rankPropProt *next;  /* Next in singly linked list. */
    char *qSpId;	/* swissprot id of query protein */
    char *tSpId;	/* swissprot id of target protein */
    float score;	/* rankp score */
    double qtEVal;	/* query to target psi-blast E-value */
    double tqEVal;	/* target to query psi-blast E-value */
    };

void rankPropProtStaticLoad(char **row, struct rankPropProt *ret);
/* Load a row from rankPropProt table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct rankPropProt *rankPropProtLoad(char **row);
/* Load a rankPropProt from row fetched with select * from rankPropProt
 * from database.  Dispose of this with rankPropProtFree(). */

struct rankPropProt *rankPropProtLoadAll(char *fileName);
/* Load all rankPropProt from whitespace-separated file.
 * Dispose of this with rankPropProtFreeList(). */

struct rankPropProt *rankPropProtLoadAllByChar(char *fileName, char chopper);
/* Load all rankPropProt from chopper separated file.
 * Dispose of this with rankPropProtFreeList(). */

#define rankPropProtLoadAllByTab(a) rankPropProtLoadAllByChar(a, '\t');
/* Load all rankPropProt from tab separated file.
 * Dispose of this with rankPropProtFreeList(). */

struct rankPropProt *rankPropProtCommaIn(char **pS, struct rankPropProt *ret);
/* Create a rankPropProt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rankPropProt */

void rankPropProtFree(struct rankPropProt **pEl);
/* Free a single dynamically allocated rankPropProt such as created
 * with rankPropProtLoad(). */

void rankPropProtFreeList(struct rankPropProt **pList);
/* Free a list of dynamically allocated rankPropProt's */

void rankPropProtOutput(struct rankPropProt *el, FILE *f, char sep, char lastSep);
/* Print out rankPropProt.  Separate fields with sep. Follow last field with lastSep. */

#define rankPropProtTabOut(el,f) rankPropProtOutput(el,f,'\t','\n');
/* Print out rankPropProt as a line in a tab-separated file. */

#define rankPropProtCommaOut(el,f) rankPropProtOutput(el,f,',',',');
/* Print out rankPropProt as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* RANKPROPPROT_H */

