/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.jstestdriver.CommandTask;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileUploader;
import com.google.jstestdriver.HeartBeatManager;
import com.google.jstestdriver.JsTestDriverFileFilter;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.util.StopWatch;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTaskFactory {
    private final JsTestDriverFileFilter filter;
    private final FileLoader fileLoader;
    private final StopWatch stopWatch;
    private final Set<FileInfoScheme> schemes;
    private final HandlerPathPrefix pathPrefix;

    @Inject
    public CommandTaskFactory(JsTestDriverFileFilter filter, FileLoader fileLoader, Provider<HeartBeatManager> heartBeatProvider, StopWatch stopWatch, Set<FileInfoScheme> schemes, @Named(value="serverHandlerPrefix") HandlerPathPrefix pathPrefix) {
        this.filter = filter;
        this.fileLoader = fileLoader;
        this.stopWatch = stopWatch;
        this.schemes = schemes;
        this.pathPrefix = pathPrefix;
    }

    public CommandTask getCommandTask(ResponseStream stream, String baseUrl, Server server, Map<String, String> params, boolean upload) {
        return new CommandTask(stream, baseUrl, server, params, upload, this.stopWatch, new FileUploader(this.stopWatch, server, baseUrl, this.fileLoader, this.filter, this.schemes, this.pathPrefix));
    }
}

